/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.LoaderException;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class ModClassLoader
extends URLClassLoader {
    private static final List<String> STANDARD_LIBRARIES = ImmutableList.of("jinput.jar", "lwjgl.jar", "lwjgl_util.jar");
    private LaunchClassLoader mainClassLoader;

    public ModClassLoader(ClassLoader classLoader) {
        super(new URL[0], (ClassLoader)null);
        this.mainClassLoader = (LaunchClassLoader)classLoader;
    }

    public void addFile(File serializable) {
        serializable = serializable.toURI().toURL();
        this.mainClassLoader.addURL((URL)serializable);
    }

    @Override
    public Class<?> loadClass(String string) {
        return this.mainClassLoader.loadClass(string);
    }

    public File[] getParentSources() {
        List<URL> list = this.mainClassLoader.getSources();
        File[] fileArray = new File[list.size()];
        try {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                fileArray[i2] = new File(list.get(i2).toURI());
            }
            return fileArray;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new LoaderException(uRISyntaxException);
        }
    }

    public List<String> getDefaultLibraries() {
        return STANDARD_LIBRARIES;
    }

    public void clearNegativeCacheFor(Set<String> set) {
        this.mainClassLoader.clearNegativeEntries(set);
    }
}

