/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import argo.jdom.JdomParser;
import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import argo.saj.InvalidSyntaxException;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.ModMetadata;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;

public class MetadataCollection {
    private static JdomParser parser = new JdomParser();
    private Map<String, ModMetadata> metadatas = Maps.newHashMap();
    private int metadataVersion = 1;

    public static MetadataCollection from(InputStream object, String string) {
        if (object == null) {
            return new MetadataCollection();
        }
        object = new InputStreamReader((InputStream)object);
        try {
            object = parser.parse((Reader)object);
            if (((JsonNode)object).hasElements()) {
                return MetadataCollection.parse10ModInfo((JsonRootNode)object);
            }
            return MetadataCollection.parseModInfo((JsonRootNode)object);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return new MetadataCollection();
        }
        catch (Exception exception) {
            object = exception;
            throw Throwables.propagate(exception);
        }
    }

    private static MetadataCollection parseModInfo(JsonRootNode jsonRootNode) {
        MetadataCollection metadataCollection = new MetadataCollection();
        new MetadataCollection().metadataVersion = Integer.parseInt(jsonRootNode.getNumberValue("modinfoversion"));
        metadataCollection.parseModMetadataList(jsonRootNode.getNode("modlist"));
        return metadataCollection;
    }

    private static MetadataCollection parse10ModInfo(JsonRootNode jsonRootNode) {
        MetadataCollection metadataCollection = new MetadataCollection();
        metadataCollection.parseModMetadataList(jsonRootNode);
        return metadataCollection;
    }

    private void parseModMetadataList(JsonNode object) {
        for (JsonNode jsonNode : ((JsonNode)((Object)object)).getElements()) {
            ModMetadata object2 = new ModMetadata(jsonNode);
            this.metadatas.put(object2.modId, object2);
        }
    }

    public ModMetadata getMetadataForId(String string, Map<String, Object> map) {
        if (!this.metadatas.containsKey(string)) {
            ModMetadata modMetadata = new ModMetadata();
            new ModMetadata().modId = string;
            modMetadata.name = (String)map.get("name");
            modMetadata.version = (String)map.get("version");
            modMetadata.autogenerated = true;
            this.metadatas.put(string, modMetadata);
        }
        return this.metadatas.get(string);
    }
}

