/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import cpw.mods.fml.common.FMLModContainer$1;
import cpw.mods.fml.common.FMLModContainer$2;
import cpw.mods.fml.common.ILanguageAdapter;
import cpw.mods.fml.common.ILanguageAdapter$JavaAdapter;
import cpw.mods.fml.common.ILanguageAdapter$ScalaAdapter;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ASMDataTable$ASMData;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.event.FMLEvent;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;
import java.io.File;
import java.io.FileInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FMLModContainer
implements ModContainer {
    private Mod modDescriptor;
    private Object modInstance;
    private File source;
    private ModMetadata modMetadata;
    private String className;
    private Map<String, Object> descriptor;
    private boolean enabled = true;
    private String internalVersion;
    private boolean overridesMetadata;
    private EventBus eventBus;
    private LoadController controller;
    private DefaultArtifactVersion processedVersion;
    private boolean isNetworkMod;
    private static final BiMap<Class<? extends FMLEvent>, Class<? extends Annotation>> modAnnotationTypes = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(FMLPreInitializationEvent.class, Mod.PreInit.class)).put(FMLInitializationEvent.class, Mod.Init.class)).put(FMLPostInitializationEvent.class, Mod.PostInit.class)).put(FMLServerAboutToStartEvent.class, Mod.ServerAboutToStart.class)).put(FMLServerStartedEvent.class, Mod.ServerStarted.class)).put(FMLServerStoppingEvent.class, Mod.ServerStopping.class)).put(FMLServerStoppedEvent.class, Mod.ServerStopped.class)).put(FMLInterModComms.IMCEvent.class, Mod.IMCCallback.class)).put(FMLFingerprintViolationEvent.class, Mod.FingerprintWarning.class)).build();
    private static final BiMap<Class<? extends Annotation>, Class<? extends FMLEvent>> modTypeAnnotations = modAnnotationTypes.inverse();
    private String annotationDependencies;
    private VersionRange minecraftAccepted;
    private boolean fingerprintNotPresent;
    private Set<String> sourceFingerprints;
    private Certificate certificate;
    private String modLanguage;
    private ILanguageAdapter languageAdapter;
    private ListMultimap<Class<? extends FMLEvent>, Method> eventMethods;
    private Map<String, String> customModProperties;
    private ModCandidate candidate;

    public FMLModContainer(String string, ModCandidate modCandidate, Map<String, Object> map) {
        this.className = string;
        this.source = modCandidate.getModContainer();
        this.candidate = modCandidate;
        this.descriptor = map;
        this.modLanguage = (String)map.get("modLanguage");
        this.languageAdapter = "scala".equals(this.modLanguage) ? new ILanguageAdapter$ScalaAdapter() : new ILanguageAdapter$JavaAdapter();
        this.eventMethods = ArrayListMultimap.create();
    }

    private ILanguageAdapter getLanguageAdapter() {
        return this.languageAdapter;
    }

    @Override
    public String getModId() {
        return (String)this.descriptor.get("modid");
    }

    @Override
    public String getName() {
        return this.modMetadata.name;
    }

    @Override
    public String getVersion() {
        return this.internalVersion;
    }

    @Override
    public File getSource() {
        return this.source;
    }

    @Override
    public ModMetadata getMetadata() {
        return this.modMetadata;
    }

    @Override
    public void bindMetadata(MetadataCollection object) {
        this.modMetadata = ((MetadataCollection)object).getMetadataForId(this.getModId(), this.descriptor);
        if (this.descriptor.containsKey("useMetadata")) {
            boolean bl = this.overridesMetadata = (Boolean)this.descriptor.get("useMetadata") == false;
        }
        if (this.overridesMetadata || !this.modMetadata.useDependencyInformation) {
            object = Sets.newHashSet();
            ArrayList<ArtifactVersion> arrayList = Lists.newArrayList();
            ArrayList<ArtifactVersion> arrayList2 = Lists.newArrayList();
            this.annotationDependencies = (String)this.descriptor.get("dependencies");
            this.modMetadata.requiredMods = object;
            this.modMetadata.dependencies = arrayList;
            this.modMetadata.dependants = arrayList2;
        }
        if (Strings.isNullOrEmpty(this.modMetadata.name)) {
            this.modMetadata.name = this.getModId();
        }
        this.internalVersion = (String)this.descriptor.get("version");
        if (Strings.isNullOrEmpty(this.internalVersion) && (object = this.searchForVersionProperties()) != null) {
            this.internalVersion = ((Properties)object).getProperty(this.getModId() + ".version");
        }
        if (Strings.isNullOrEmpty(this.internalVersion) && !Strings.isNullOrEmpty(this.modMetadata.version)) {
            this.internalVersion = this.modMetadata.version;
        }
        if (Strings.isNullOrEmpty(this.internalVersion)) {
            this.internalVersion = "1.0";
            this.modMetadata.version = "1.0";
        }
        object = "[1.6,1.7)";
        if (!Strings.isNullOrEmpty("[1.6,1.7)")) {
            this.minecraftAccepted = VersionParser.parseRange((String)object);
            return;
        }
        this.minecraftAccepted = Loader.instance().getMinecraftModContainer().getStaticVersionRange();
    }

    public Properties searchForVersionProperties() {
        try {
            File file;
            Properties properties = null;
            if (this.getSource().isFile()) {
                ZipFile zipFile = new ZipFile(this.getSource());
                ZipEntry zipEntry = zipFile.getEntry("version.properties");
                if (zipEntry != null) {
                    properties = new Properties();
                    properties.load(zipFile.getInputStream(zipEntry));
                }
                zipFile.close();
            } else if (this.getSource().isDirectory() && (file = new File(this.getSource(), "version.properties")).exists() && file.isFile()) {
                properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            return properties;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            Throwables.propagateIfPossible(exception);
            return null;
        }
    }

    @Override
    public void setEnabledState(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public Set<ArtifactVersion> getRequirements() {
        return this.modMetadata.requiredMods;
    }

    @Override
    public List<ArtifactVersion> getDependencies() {
        return this.modMetadata.dependencies;
    }

    @Override
    public List<ArtifactVersion> getDependants() {
        return this.modMetadata.dependants;
    }

    @Override
    public String getSortingRules() {
        if (this.overridesMetadata || !this.modMetadata.useDependencyInformation) {
            return Strings.nullToEmpty(this.annotationDependencies);
        }
        return this.modMetadata.printableSortingRules();
    }

    @Override
    public boolean matches(Object object) {
        return object == this.modInstance;
    }

    @Override
    public Object getMod() {
        return this.modInstance;
    }

    @Override
    public boolean registerBus(EventBus eventBus, LoadController loadController) {
        if (this.enabled) {
            this.eventBus = eventBus;
            this.controller = loadController;
            this.eventBus.register(this);
            return true;
        }
        return false;
    }

    private Method gatherAnnotations(Class<?> methodArray) {
        Method method = null;
        for (Method method2 : methodArray.getDeclaredMethods()) {
            for (Annotation annotation : method2.getAnnotations()) {
                if (modTypeAnnotations.containsKey(annotation.annotationType())) {
                    Object[] objectArray = new Class[]{(Class)modTypeAnnotations.get(annotation.annotationType())};
                    if (!Arrays.equals(method2.getParameterTypes(), objectArray)) continue;
                    method2.setAccessible(true);
                    this.eventMethods.put((Class<? extends FMLEvent>)modTypeAnnotations.get(annotation.annotationType()), method2);
                    continue;
                }
                if (annotation.annotationType().equals(Mod.EventHandler.class)) {
                    if (method2.getParameterTypes().length != 1 || !modAnnotationTypes.containsKey(method2.getParameterTypes()[0])) continue;
                    method2.setAccessible(true);
                    this.eventMethods.put(method2.getParameterTypes()[0], method2);
                    continue;
                }
                if (!annotation.annotationType().equals(Mod.InstanceFactory.class)) continue;
                if (Modifier.isStatic(method2.getModifiers()) && method2.getParameterTypes().length == 0 && method == null) {
                    method2.setAccessible(true);
                    method = method2;
                    continue;
                }
                if (!Modifier.isStatic(method2.getModifiers())) continue;
                method2.getParameterTypes();
            }
        }
        return method;
    }

    private void processFieldAnnotations(ASMDataTable object) {
        object = ((ASMDataTable)object).getAnnotationsFor(this);
        this.parseSimpleFieldAnnotation((SetMultimap<String, ASMDataTable$ASMData>)object, Mod.Instance.class.getName(), new FMLModContainer$1(this));
        this.parseSimpleFieldAnnotation((SetMultimap<String, ASMDataTable$ASMData>)object, Mod.Metadata.class.getName(), new FMLModContainer$2(this));
    }

    /*
     * WARNING - void declaration
     */
    private void parseSimpleFieldAnnotation(SetMultimap<String, ASMDataTable$ASMData> object, String object22, Function<ModContainer, Object> function) {
        for (ASMDataTable$ASMData aSMDataTable$ASMData : object.get(object22)) {
            void var2_9;
            String string = (String)aSMDataTable$ASMData.getAnnotationInfo().get("value");
            Field field = null;
            Object var6_14 = null;
            ModContainer modContainer = this;
            boolean bl = false;
            Class<?> clazz = this.modInstance.getClass();
            if (!Strings.isNullOrEmpty(string)) {
                modContainer = Loader.isModLoaded(string) ? Loader.instance().getIndexedModList().get(string) : null;
            }
            if (modContainer != null) {
                try {
                    void var3_11;
                    clazz = Class.forName(aSMDataTable$ASMData.getClassName(), true, Loader.instance().getModClassLoader());
                    field = clazz.getDeclaredField(aSMDataTable$ASMData.getObjectName());
                    field.setAccessible(true);
                    bl = Modifier.isStatic(field.getModifiers());
                    var6_14 = var3_11.apply(modContainer);
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    Throwables.propagateIfPossible(exception);
                }
            }
            if (field == null) continue;
            Object var2_7 = null;
            if (!bl) {
                Object object2 = this.modInstance;
                if (!this.modInstance.getClass().equals(clazz)) continue;
            }
            field.set(var2_9, var6_14);
        }
    }

    public void handleModStateEvent(FMLEvent fMLEvent) {
        if (!this.eventMethods.containsKey(fMLEvent.getClass())) {
            return;
        }
        try {
            for (Method method : this.eventMethods.get(fMLEvent.getClass())) {
                method.invoke(this.modInstance, fMLEvent);
            }
            return;
        }
        catch (Throwable throwable) {
            this.controller.errorOccurred(this, throwable);
            return;
        }
    }

    @Override
    public ArtifactVersion getProcessedVersion() {
        if (this.processedVersion == null) {
            this.processedVersion = new DefaultArtifactVersion(this.getModId(), this.getVersion());
        }
        return this.processedVersion;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isNetworkMod() {
        return this.isNetworkMod;
    }

    @Override
    public String getDisplayVersion() {
        return this.modMetadata.version;
    }

    @Override
    public VersionRange acceptableMinecraftVersionRange() {
        return this.minecraftAccepted;
    }

    @Override
    public Certificate getSigningCertificate() {
        return this.certificate;
    }

    public final String toString() {
        return "FMLMod:" + this.getModId() + "{" + this.getVersion() + "}";
    }

    @Override
    public Map<String, String> getCustomModProperties() {
        return this.customModProperties;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        try {
            if (this.getSource().isDirectory()) {
                return Class.forName("cpw.mods.fml.client.FMLFolderResourcePack", true, this.getClass().getClassLoader());
            }
            return Class.forName("cpw.mods.fml.client.FMLFileResourcePack", true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public Map<String, String> getSharedModDescriptor() {
        HashMap<String, String> hashMap = Maps.newHashMap();
        hashMap.put("modsystem", "FML");
        hashMap.put("id", this.getModId());
        hashMap.put("version", this.getDisplayVersion());
        hashMap.put("name", this.getName());
        hashMap.put("url", this.modMetadata.url);
        hashMap.put("authors", this.modMetadata.getAuthorList());
        hashMap.put("description", this.modMetadata.description);
        return hashMap;
    }
}

