/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FMLCommonHandler {
    private static final FMLCommonHandler INSTANCE = new FMLCommonHandler();
    private IFMLSidedHandler sidedDelegate;
    private Class<?> forge;
    private boolean noForge;
    private List<String> brandings;
    private List<ICrashCallable> crashCallables = Lists.newArrayList(Loader.instance().getCallableCrashInformation());

    public static FMLCommonHandler instance() {
        return INSTANCE;
    }

    public ModContainer findContainerFor(Object object) {
        return (ModContainer)Loader.instance().getReversedModObjectList().get(object);
    }

    public Logger getFMLLogger() {
        return FMLLog.getLogger();
    }

    public Side getSide() {
        return this.sidedDelegate.getSide();
    }

    public void raiseException(Throwable throwable, String string, boolean bl) {
        FMLLog.log(Level.SEVERE, throwable, "Something raised an exception. The message was '%s'. 'stopGame' is %b", string, bl);
        if (bl) {
            this.getSidedDelegate().haltGame(string, throwable);
        }
    }

    private Class<?> findMinecraftForge() {
        if (this.forge == null && !this.noForge) {
            try {
                this.forge = Class.forName("net.minecraftforge.common.MinecraftForge");
            }
            catch (Exception exception) {
                this.noForge = true;
            }
        }
        return this.forge;
    }

    private Object callForgeMethod(String string) {
        if (this.noForge) {
            return null;
        }
        try {
            return this.findMinecraftForge().getMethod(string, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void computeBranding() {
        if (this.brandings == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add(Loader.instance().getMCVersionString());
            builder.add(Loader.instance().getMCPVersionString());
            builder.add("FML v" + Loader.instance().getFMLVersionString());
            String string = (String)this.callForgeMethod("getBrandingVersion");
            if (!Strings.isNullOrEmpty(string)) {
                builder.add(string);
            }
            if (this.sidedDelegate != null) {
                builder.addAll(this.sidedDelegate.getAdditionalBrandingInformation());
            }
            if (Loader.instance().getFMLBrandingProperties().containsKey("fmlbranding")) {
                builder.add(Loader.instance().getFMLBrandingProperties().get("fmlbranding"));
            }
            int n2 = Loader.instance().getModList().size();
            int n3 = Loader.instance().getActiveModList().size();
            builder.add(String.format("%d mod%s loaded, %d mod%s active", n2, n2 != 1 ? "s" : "", n3, n3 != 1 ? "s" : ""));
            this.brandings = builder.build();
        }
    }

    public List<String> getBrandings() {
        if (this.brandings == null) {
            this.computeBranding();
        }
        return ImmutableList.copyOf(this.brandings);
    }

    public IFMLSidedHandler getSidedDelegate() {
        return this.sidedDelegate;
    }

    public void handleServerStarted() {
        Loader.instance().serverStarted();
    }

    public void handleServerStopping() {
        Loader.instance().serverStopping();
    }

    public void onServerStarted() {
        this.sidedDelegate.finishServerLoading();
    }

    public boolean shouldServerBeKilledQuietly() {
        if (this.sidedDelegate == null) {
            return false;
        }
        return this.sidedDelegate.shouldServerShouldBeKilledQuietly();
    }

    public String getModName() {
        ArrayList<String> arrayList = Lists.newArrayListWithExpectedSize(3);
        arrayList.add("fml");
        if (!this.noForge) {
            arrayList.add("forge");
        }
        if (Loader.instance().getFMLBrandingProperties().containsKey("snooperbranding")) {
            arrayList.add(Loader.instance().getFMLBrandingProperties().get("snooperbranding"));
        }
        return Joiner.on(',').join(arrayList);
    }

    public void addModToResourcePack(ModContainer modContainer) {
        this.sidedDelegate.addModAsResource(modContainer);
    }

    public void updateResourcePackList() {
        this.sidedDelegate.updateResourcePackList();
    }

    public String getCurrentLanguage() {
        return this.sidedDelegate.getCurrentLanguage();
    }
}

