/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.client.FileDownload;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.RealmsSharedConstants;
import net.minecraft.realms.Tezzelator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class DownloadLatestWorldScreen
extends RealmsScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RealmsScreen lastScreen;
    private final String downloadLink;
    private RealmsButton cancelButton;
    private final String worldName;
    private final DownloadStatus downloadStatus;
    private volatile String errorMessage = null;
    private volatile String status = null;
    private volatile String progress = null;
    private volatile boolean cancelled = false;
    private volatile boolean showDots = true;
    private volatile boolean finished = false;
    private volatile boolean extracting = false;
    private Long previousWrittenBytes = null;
    private Long previousTimeSnapshot = null;
    private long bytesPersSecond = 0L;
    private int animTick = 0;
    private static final String[] DOTS = new String[]{"", ".", ". .", ". . ."};
    private int dotIndex = 0;
    private static final ReentrantLock downloadLock = new ReentrantLock();

    public DownloadLatestWorldScreen(RealmsScreen lastScreen, String downloadLink, String worldName) {
        this.lastScreen = lastScreen;
        this.worldName = worldName;
        this.downloadLink = downloadLink;
        this.downloadStatus = new DownloadStatus();
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        this.cancelButton = DownloadLatestWorldScreen.newButton((int)0, (int)(this.width() / 2 - 100), (int)(this.height() - 42), (int)200, (int)20, (String)DownloadLatestWorldScreen.getLocalizedString((String)"gui.cancel"));
        this.buttonsAdd(this.cancelButton);
        this.downloadSave();
    }

    public void tick() {
        super.tick();
        ++this.animTick;
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == 0) {
            this.cancelled = true;
            this.backButtonClicked();
        }
    }

    public void keyPressed(char ch, int eventKey) {
        if (eventKey == 1) {
            this.cancelled = true;
            this.backButtonClicked();
        }
    }

    private void backButtonClicked() {
        Realms.setScreen((RealmsScreen)this.lastScreen);
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        if (this.extracting && !this.finished) {
            this.status = DownloadLatestWorldScreen.getLocalizedString((String)"mco.download.extracting");
        }
        this.drawCenteredString(DownloadLatestWorldScreen.getLocalizedString((String)"mco.download.title"), this.width() / 2, 20, 0xFFFFFF);
        this.drawCenteredString(this.status, this.width() / 2, 50, 0xFFFFFF);
        if (this.showDots) {
            this.drawDots();
        }
        if (this.downloadStatus.bytesWritten != 0L && !this.cancelled) {
            this.drawProgressBar();
            this.drawDownloadSpeed();
        }
        if (this.errorMessage != null) {
            this.drawCenteredString(this.errorMessage, this.width() / 2, 110, 0xFF0000);
        }
        super.render(xm, ym, a);
    }

    private void drawDots() {
        int statusWidth = this.fontWidth(this.status);
        if (this.animTick % 10 == 0) {
            ++this.dotIndex;
        }
        this.drawString(DOTS[this.dotIndex % DOTS.length], this.width() / 2 + statusWidth / 2 + 5, 50, 0xFFFFFF);
    }

    private void drawProgressBar() {
        double percentage = this.downloadStatus.bytesWritten.doubleValue() / this.downloadStatus.totalBytes.doubleValue() * 100.0;
        this.progress = String.format("%.1f", percentage);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3553);
        Tezzelator t = Tezzelator.instance;
        t.begin();
        double base = this.width() / 2 - 100;
        double diff = 0.5;
        t.color(0xD9D2D2);
        t.vertex(base - diff, 95.0 + diff, 0.0);
        t.vertex(base + 200.0 * percentage / 100.0 + diff, 95.0 + diff, 0.0);
        t.vertex(base + 200.0 * percentage / 100.0 + diff, 80.0 - diff, 0.0);
        t.vertex(base - diff, 80.0 - diff, 0.0);
        t.color(0x808080);
        t.vertex(base, 95.0, 0.0);
        t.vertex(base + 200.0 * percentage / 100.0, 95.0, 0.0);
        t.vertex(base + 200.0 * percentage / 100.0, 80.0, 0.0);
        t.vertex(base, 80.0, 0.0);
        t.end();
        GL11.glEnable((int)3553);
        this.drawCenteredString(this.progress + " %", this.width() / 2, 84, 0xFFFFFF);
    }

    private void drawDownloadSpeed() {
        if (this.animTick % RealmsSharedConstants.TICKS_PER_SECOND == 0) {
            if (this.previousWrittenBytes != null) {
                long timeElapsed = System.currentTimeMillis() - this.previousTimeSnapshot;
                if (timeElapsed == 0L) {
                    timeElapsed = 1L;
                }
                this.bytesPersSecond = 1000L * (this.downloadStatus.bytesWritten - this.previousWrittenBytes) / timeElapsed;
                this.drawDownloadSpeed0(this.bytesPersSecond);
            }
            this.previousWrittenBytes = this.downloadStatus.bytesWritten;
            this.previousTimeSnapshot = System.currentTimeMillis();
        } else {
            this.drawDownloadSpeed0(this.bytesPersSecond);
        }
    }

    private void drawDownloadSpeed0(long bytesPersSecond) {
        if (bytesPersSecond > 0L) {
            int progressLength = this.fontWidth(this.progress);
            String stringPresentation = "(" + DownloadLatestWorldScreen.humanReadableByteCount(bytesPersSecond) + ")";
            this.drawString(stringPresentation, this.width() / 2 + progressLength / 2 + 15, 84, 0xFFFFFF);
        }
    }

    public static String humanReadableByteCount(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "KMGTPE".charAt(exp - 1) + "";
        return String.format("%.1f %sB/s", (double)bytes / Math.pow(unit, exp), pre);
    }

    public void mouseEvent() {
        super.mouseEvent();
    }

    private void downloadSave() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (!downloadLock.tryLock(1L, TimeUnit.SECONDS)) {
                        return;
                    }
                    DownloadLatestWorldScreen.this.status = RealmsScreen.getLocalizedString((String)"mco.download.preparing");
                    if (DownloadLatestWorldScreen.this.cancelled) {
                        DownloadLatestWorldScreen.this.downloadCancelled();
                        return;
                    }
                    DownloadLatestWorldScreen.this.status = RealmsScreen.getLocalizedString((String)"mco.download.downloading", (Object[])new Object[]{DownloadLatestWorldScreen.this.worldName});
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.download(DownloadLatestWorldScreen.this.downloadLink, DownloadLatestWorldScreen.this.worldName, DownloadLatestWorldScreen.this.downloadStatus, DownloadLatestWorldScreen.this.getLevelStorageSource());
                    while (!fileDownload.isFinished()) {
                        if (fileDownload.isError()) {
                            fileDownload.cancel();
                            DownloadLatestWorldScreen.this.errorMessage = RealmsScreen.getLocalizedString((String)"mco.download.failed");
                            DownloadLatestWorldScreen.this.cancelButton.msg(RealmsScreen.getLocalizedString((String)"gui.done"));
                            return;
                        }
                        if (fileDownload.isExtracting()) {
                            DownloadLatestWorldScreen.this.extracting = true;
                        }
                        if (DownloadLatestWorldScreen.this.cancelled) {
                            fileDownload.cancel();
                            DownloadLatestWorldScreen.this.downloadCancelled();
                            return;
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.error("Failed to check Realms backup download status");
                        }
                    }
                    DownloadLatestWorldScreen.this.finished = true;
                    DownloadLatestWorldScreen.this.status = RealmsScreen.getLocalizedString((String)"mco.download.done");
                    DownloadLatestWorldScreen.this.cancelButton.msg(RealmsScreen.getLocalizedString((String)"gui.done"));
                }
                catch (InterruptedException e) {
                    LOGGER.error("Could not acquire upload lock");
                }
                catch (Exception e) {
                    DownloadLatestWorldScreen.this.errorMessage = RealmsScreen.getLocalizedString((String)"mco.download.failed");
                    e.printStackTrace();
                }
                finally {
                    if (!downloadLock.isHeldByCurrentThread()) {
                        return;
                    }
                    downloadLock.unlock();
                    DownloadLatestWorldScreen.this.showDots = false;
                    DownloadLatestWorldScreen.this.buttonsRemove(DownloadLatestWorldScreen.this.cancelButton);
                }
            }
        }.start();
    }

    private void downloadCancelled() {
        this.status = DownloadLatestWorldScreen.getLocalizedString((String)"mco.download.cancelled");
    }

    public class DownloadStatus {
        public volatile Long bytesWritten = 0L;
        public volatile Long totalBytes = 0L;
    }
}

