/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.realmsclient.RealmsVersion;
import com.mojang.realmsclient.client.Ping;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.PingResult;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RegionPingResult;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.exception.RetryCallException;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.mojang.realmsclient.gui.RealmsConnectTask;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import com.mojang.realmsclient.gui.screens.BuyRealmsScreen;
import com.mojang.realmsclient.gui.screens.CreateRealmsWorldScreen;
import com.mojang.realmsclient.gui.screens.LongConfirmationScreen;
import com.mojang.realmsclient.gui.screens.LongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.PendingInvitationScreen;
import com.mojang.realmsclient.gui.screens.RealmsClientOutdatedScreen;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsMth;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.RealmsScrolledSelectionList;
import net.minecraft.realms.RealmsServerStatusPinger;
import net.minecraft.realms.Tezzelator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class RealmsMainScreen
extends RealmsScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean overrideConfigure = false;
    private static boolean stageEnabled = false;
    protected static final int BACK_BUTTON_ID = 0;
    protected static final int PLAY_BUTTON_ID = 1;
    protected static final int BUY_BUTTON_ID = 2;
    protected static final int CONFIGURE_BUTTON_ID = 3;
    protected static final int GET_MORE_INFO_BUTTON_ID = 4;
    protected static final int LEAVE_BUTTON_ID = 5;
    private static final String ON_ICON_LOCATION = "realms:textures/gui/realms/on_icon.png";
    private static final String OFF_ICON_LOCATION = "realms:textures/gui/realms/off_icon.png";
    private static final String EXPIRED_ICON_LOCATION = "realms:textures/gui/realms/expired_icon.png";
    private static final String INVITATION_ICONS_LOCATION = "realms:textures/gui/realms/invitation_icons.png";
    private static final String INVITE_ICON_LOCATION = "realms:textures/gui/realms/invite_icon.png";
    private static final String WORLDICON_LOCATION = "realms:textures/gui/realms/world_icon.png";
    private static final String LOGO_LOCATION = "realms:textures/gui/title/realms.png";
    private static RealmsDataFetcher realmsDataFetcher = new RealmsDataFetcher();
    private static RealmsServerStatusPinger statusPinger = new RealmsServerStatusPinger();
    private static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).build());
    private static int lastScrollYPosition = -1;
    private RealmsScreen lastScreen;
    private volatile ServerSelectionList serverSelectionList;
    private long selectedServerId = -1L;
    private RealmsButton configureButton;
    private RealmsButton leaveButton;
    private RealmsButton playButton;
    private RealmsButton buyButton;
    private String toolTip;
    private List<RealmsServer> realmsServers = Lists.newArrayList();
    private static final String mcoInfoUrl = "https://minecraft.net/realms";
    private volatile int numberOfPendingInvites = 0;
    public static final int EXPIRATION_NOTIFICATION_DAYS = 7;
    private int animTick;
    private static volatile boolean mcoEnabled;
    private static boolean checkedMcoAvailability;
    private static RealmsScreen realmsGenericErrorScreen;
    private static boolean regionsPinged;
    private boolean onLink = false;
    private int mindex = 0;
    private char[] mchars = new char[]{'3', '2', '1', '4', '5', '6'};
    private int sindex = 0;
    private char[] schars = new char[]{'9', '8', '7', '1', '2', '3'};

    public RealmsMainScreen(RealmsScreen lastScreen) {
        this.lastScreen = lastScreen;
        this.checkIfMcoEnabled();
    }

    public void mouseEvent() {
        super.mouseEvent();
        this.serverSelectionList.mouseEvent();
    }

    public void init() {
        if (realmsGenericErrorScreen != null) {
            Realms.setScreen((RealmsScreen)realmsGenericErrorScreen);
            return;
        }
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        this.postInit();
        if (this.isMcoEnabled()) {
            realmsDataFetcher.init();
        }
    }

    public void postInit() {
        RealmsServer server;
        this.playButton = RealmsMainScreen.newButton((int)1, (int)(this.width() / 2 - 154), (int)(this.height() - 52), (int)154, (int)20, (String)RealmsMainScreen.getLocalizedString((String)"mco.selectServer.play"));
        this.buttonsAdd(this.playButton);
        this.leaveButton = RealmsMainScreen.newButton((int)5, (int)(this.width() / 2 - 154), (int)(this.height() - 28), (int)102, (int)20, (String)RealmsMainScreen.getLocalizedString((String)"mco.selectServer.leave"));
        this.buttonsAdd(this.leaveButton);
        this.configureButton = RealmsMainScreen.newButton((int)3, (int)(this.width() / 2 + 6), (int)(this.height() - 52), (int)154, (int)20, (String)RealmsMainScreen.getLocalizedString((String)"mco.selectServer.configure"));
        this.buttonsAdd(this.configureButton);
        this.buyButton = RealmsMainScreen.newButton((int)2, (int)(this.width() / 2 - 48), (int)(this.height() - 28), (int)102, (int)20, (String)RealmsMainScreen.getLocalizedString((String)"mco.selectServer.buy"));
        this.buttonsAdd(this.buyButton);
        this.buttonsAdd(RealmsMainScreen.newButton((int)0, (int)(this.width() / 2 + 58), (int)(this.height() - 28), (int)102, (int)20, (String)RealmsMainScreen.getLocalizedString((String)"gui.back")));
        this.serverSelectionList = new ServerSelectionList();
        if (lastScrollYPosition != -1) {
            this.serverSelectionList.scroll(lastScrollYPosition);
        }
        this.playButton.active((server = this.findServer(this.selectedServerId)) != null && server.state == RealmsServer.State.OPEN && !server.expired);
        this.configureButton.active(overrideConfigure || server != null && server.state != RealmsServer.State.ADMIN_LOCK && server.owner.equals(Realms.getName()));
        this.leaveButton.active(server != null && !server.owner.equals(Realms.getName()));
    }

    public void tick() {
        ++this.animTick;
        if (!this.isMcoEnabled()) {
            return;
        }
        realmsDataFetcher.init();
        if (realmsDataFetcher.isFetchedSinceLastTry(RealmsDataFetcher.Task.SERVER_LIST)) {
            List<RealmsServer> newServers = realmsDataFetcher.getServers();
            boolean ownsNonExpiredRealmServer = false;
            block0: for (RealmsServer retrievedServer : newServers) {
                if (this.isSelfOwnedNonExpiredServer(retrievedServer)) {
                    ownsNonExpiredRealmServer = true;
                }
                for (RealmsServer oldServer : this.realmsServers) {
                    if (retrievedServer.id != oldServer.id) continue;
                    retrievedServer.latestStatFrom(oldServer);
                    continue block0;
                }
            }
            this.realmsServers = newServers;
            if (!regionsPinged && ownsNonExpiredRealmServer) {
                regionsPinged = true;
                this.pingRegions();
            }
        }
        if (realmsDataFetcher.isFetchedSinceLastTry(RealmsDataFetcher.Task.PENDING_INVITE)) {
            this.numberOfPendingInvites = realmsDataFetcher.getPendingInvitesCount();
        }
        realmsDataFetcher.markClean();
    }

    private void pingRegions() {
        new Thread(){

            @Override
            public void run() {
                List<RegionPingResult> regionPingResultList = Ping.pingAllRegions();
                RealmsClient client = RealmsClient.createRealmsClient();
                PingResult pingResult = new PingResult();
                pingResult.pingResults = regionPingResultList;
                pingResult.worldIds = RealmsMainScreen.this.getOwnedNonExpiredWorldIds();
                try {
                    client.sendPingResults(pingResult);
                }
                catch (Throwable t) {
                    LOGGER.warn("Could not send ping result to Realms: ", t);
                }
            }
        }.start();
    }

    private List<Long> getOwnedNonExpiredWorldIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (RealmsServer server : this.realmsServers) {
            if (!this.isSelfOwnedNonExpiredServer(server)) continue;
            ids.add(server.id);
        }
        return ids;
    }

    private boolean isMcoEnabled() {
        return mcoEnabled;
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == 1) {
            this.play(this.selectedServerId);
        } else if (button.id() == 3) {
            this.configureClicked();
        } else if (button.id() == 5) {
            this.leaveClicked();
        } else if (button.id() == 0) {
            this.stopRealmsFetcherAndPinger();
            Realms.setScreen((RealmsScreen)this.lastScreen);
        } else if (button.id() == 2) {
            this.saveListScrollPosition();
            this.stopRealmsFetcherAndPinger();
            Realms.setScreen((RealmsScreen)new BuyRealmsScreen(this));
        } else if (button.id() == 4) {
            this.moreInfoButtonClicked();
        }
    }

    private void checkIfMcoEnabled() {
        if (!checkedMcoAvailability) {
            checkedMcoAvailability = true;
            new Thread("MCO Availability Checker #1"){

                @Override
                public void run() {
                    RealmsClient client = RealmsClient.createRealmsClient();
                    try {
                        if (client.clientOutdated().booleanValue()) {
                            Realms.setScreen((RealmsScreen)(realmsGenericErrorScreen = new RealmsClientOutdatedScreen(RealmsMainScreen.this.lastScreen)));
                            return;
                        }
                    }
                    catch (RealmsServiceException e) {
                        LOGGER.error("Couldn't connect to realms: ", new Object[]{e.toString()});
                        if (e.httpResultCode == 401) {
                            realmsGenericErrorScreen = new RealmsGenericErrorScreen(e, RealmsMainScreen.this.lastScreen);
                        }
                        Realms.setScreen((RealmsScreen)new RealmsGenericErrorScreen(e, RealmsMainScreen.this.lastScreen));
                        return;
                    }
                    catch (IOException e) {
                        LOGGER.error("Couldn't connect to realms: ", new Object[]{e.getMessage()});
                        Realms.setScreen((RealmsScreen)new RealmsGenericErrorScreen(e.getMessage(), RealmsMainScreen.this.lastScreen));
                        return;
                    }
                    boolean retry = false;
                    for (int i = 0; i < 3; ++i) {
                        try {
                            Boolean result = client.mcoEnabled();
                            if (result.booleanValue()) {
                                LOGGER.info("Realms is available for this user");
                                mcoEnabled = true;
                            } else {
                                LOGGER.info("Realms is not available for this user");
                                mcoEnabled = false;
                            }
                        }
                        catch (RetryCallException e) {
                            retry = true;
                        }
                        catch (RealmsServiceException e) {
                            LOGGER.error("Couldn't connect to Realms: " + e.toString());
                        }
                        catch (IOException e) {
                            LOGGER.error("Couldn't parse response connecting to Realms: " + e.getMessage());
                        }
                        if (!retry) break;
                        try {
                            Thread.sleep(5000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }.start();
        }
    }

    private void switchToStage() {
        if (!stageEnabled) {
            new Thread("MCO Stage Availability Checker #1"){

                @Override
                public void run() {
                    RealmsClient client = RealmsClient.createRealmsClient();
                    try {
                        Boolean result = client.stageAvailable();
                        if (result.booleanValue()) {
                            RealmsClient.switchToStage();
                            LOGGER.info("Switched to stage");
                            stageEnabled = true;
                        } else {
                            stageEnabled = false;
                        }
                    }
                    catch (RealmsServiceException e) {
                        LOGGER.error("Couldn't connect to Realms: " + e.toString());
                    }
                    catch (IOException e) {
                        LOGGER.error("Couldn't parse response connecting to Realms: " + e.getMessage());
                    }
                }
            }.start();
        }
    }

    private void switchToProd() {
        if (stageEnabled) {
            stageEnabled = false;
            RealmsClient.switchToProd();
        }
    }

    private void stopRealmsFetcherAndPinger() {
        if (this.isMcoEnabled()) {
            realmsDataFetcher.stop();
            statusPinger.removeAll();
        }
    }

    private void moreInfoButtonClicked() {
        String line2 = RealmsMainScreen.getLocalizedString((String)"mco.more.info.question.line1");
        String line3 = RealmsMainScreen.getLocalizedString((String)"mco.more.info.question.line2");
        Realms.setScreen((RealmsScreen)new LongConfirmationScreen(this, LongConfirmationScreen.Type.Info, line2, line3, 4));
    }

    private void configureClicked() {
        RealmsServer selectedServer = this.findServer(this.selectedServerId);
        if (selectedServer != null && (Realms.getName().equals(selectedServer.owner) || overrideConfigure)) {
            this.stopRealmsFetcherAndPinger();
            this.saveListScrollPosition();
            Realms.setScreen((RealmsScreen)new RealmsConfigureWorldScreen(this, selectedServer.id));
        }
    }

    private void leaveClicked() {
        RealmsServer selectedServer = this.findServer(this.selectedServerId);
        if (selectedServer != null && !Realms.getName().equals(selectedServer.owner)) {
            this.saveListScrollPosition();
            String line2 = RealmsMainScreen.getLocalizedString((String)"mco.configure.world.leave.question.line1");
            String line3 = RealmsMainScreen.getLocalizedString((String)"mco.configure.world.leave.question.line2");
            Realms.setScreen((RealmsScreen)new LongConfirmationScreen(this, LongConfirmationScreen.Type.Info, line2, line3, 5));
        }
    }

    private void saveListScrollPosition() {
        lastScrollYPosition = this.serverSelectionList.getScroll();
    }

    private RealmsServer findServer(long id) {
        for (RealmsServer server : this.realmsServers) {
            if (server.id != id) continue;
            return server;
        }
        return null;
    }

    private int findIndex(long serverId) {
        for (int i = 0; i < this.realmsServers.size(); ++i) {
            if (this.realmsServers.get((int)i).id != serverId) continue;
            return i;
        }
        return -1;
    }

    public void confirmResult(boolean result, int id) {
        if (id == 5 && result) {
            new Thread("Realms-leave-server"){

                @Override
                public void run() {
                    try {
                        RealmsServer server = RealmsMainScreen.this.findServer(RealmsMainScreen.this.selectedServerId);
                        if (server != null) {
                            RealmsClient client = RealmsClient.createRealmsClient();
                            realmsDataFetcher.removeItem(server);
                            RealmsMainScreen.this.realmsServers.remove(server);
                            client.uninviteMyselfFrom(server.id);
                            realmsDataFetcher.removeItem(server);
                            RealmsMainScreen.this.realmsServers.remove(server);
                            RealmsMainScreen.this.updateSelectedItemPointer();
                        }
                    }
                    catch (RealmsServiceException e) {
                        LOGGER.error("Couldn't configure world");
                        Realms.setScreen((RealmsScreen)new RealmsGenericErrorScreen(e, (RealmsScreen)RealmsMainScreen.this));
                    }
                }
            }.start();
        }
        Realms.setScreen((RealmsScreen)this);
    }

    private void updateSelectedItemPointer() {
        int originalIndex = this.findIndex(this.selectedServerId);
        if (this.realmsServers.size() - 1 == originalIndex) {
            --originalIndex;
        }
        if (this.realmsServers.size() == 0) {
            originalIndex = -1;
        }
        if (originalIndex >= 0 && originalIndex < this.realmsServers.size()) {
            this.selectedServerId = this.realmsServers.get((int)originalIndex).id;
        }
    }

    public void removeSelection() {
        this.selectedServerId = -1L;
    }

    public void keyPressed(char ch, int eventKey) {
        if (eventKey == 28 || eventKey == 156) {
            this.mindex = 0;
            this.sindex = 0;
            this.buttonClicked(this.playButton);
        } else if (eventKey == 1) {
            this.mindex = 0;
            this.sindex = 0;
            this.stopRealmsFetcherAndPinger();
            Realms.setScreen((RealmsScreen)this.lastScreen);
        } else {
            if (this.mchars[this.mindex] == ch) {
                ++this.mindex;
                if (this.mindex == this.mchars.length) {
                    this.mindex = 0;
                    overrideConfigure = true;
                }
            } else {
                this.mindex = 0;
            }
            if (this.schars[this.sindex] == ch) {
                ++this.sindex;
                if (this.sindex == this.schars.length) {
                    this.sindex = 0;
                    if (!stageEnabled) {
                        this.switchToStage();
                    } else {
                        this.switchToProd();
                    }
                }
                return;
            }
            this.sindex = 0;
        }
    }

    public void render(int xm, int ym, float a) {
        this.toolTip = null;
        this.renderBackground();
        this.serverSelectionList.render(xm, ym, a);
        this.drawRealmsLogo(this.width() / 2 - 50, 7);
        this.renderLink(xm, ym);
        if (this.toolTip != null) {
            this.renderMousehoverTooltip(this.toolTip, xm, ym);
        }
        this.drawInvitationPendingIcon(xm, ym);
        if (stageEnabled) {
            this.renderStage();
        }
        super.render(xm, ym, a);
    }

    private void drawRealmsLogo(int x, int y) {
        RealmsScreen.bind((String)LOGO_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        RealmsScreen.blit((int)(x * 2), (int)(y * 2 - 5), (float)0.0f, (float)0.0f, (int)200, (int)50, (float)200.0f, (float)50.0f);
        GL11.glPopMatrix();
    }

    public void mouseClicked(int x, int y, int buttonNum) {
        if (this.inPendingInvitationArea(x, y) && this.numberOfPendingInvites != 0) {
            this.stopRealmsFetcherAndPinger();
            PendingInvitationScreen pendingInvitationScreen = new PendingInvitationScreen(this.lastScreen);
            Realms.setScreen((RealmsScreen)pendingInvitationScreen);
        }
        if (this.onLink) {
            this.browseTo(mcoInfoUrl);
        }
    }

    private void browseTo(String uri) {
        try {
            URI link = new URI(uri);
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Object o = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktopClass.getMethod("browse", URI.class).invoke(o, link);
        }
        catch (Throwable e) {
            LOGGER.error("Couldn't open link");
        }
    }

    private void drawInvitationPendingIcon(int xm, int ym) {
        boolean renderToolTip;
        int pendingInvitesCount = this.numberOfPendingInvites;
        boolean hovering = this.inPendingInvitationArea(xm, ym);
        int baseX = this.width() / 2 + 50;
        int baseY = 12;
        if (pendingInvitesCount != 0) {
            float scale = 0.25f + (1.0f + RealmsMth.sin((float)((float)this.animTick * 0.5f))) * 0.25f;
            int color = 0xFF000000 | (int)(scale * 64.0f) << 16 | (int)(scale * 64.0f) << 8 | (int)(scale * 64.0f) << 0;
            this.fillGradient(baseX - 2, 10, baseX + 18, 30, color, color);
            color = 0xFF000000 | (int)(scale * 255.0f) << 16 | (int)(scale * 255.0f) << 8 | (int)(scale * 255.0f) << 0;
            this.fillGradient(baseX - 2, 10, baseX + 18, 11, color, color);
            this.fillGradient(baseX - 2, 10, baseX - 1, 30, color, color);
            this.fillGradient(baseX + 17, 10, baseX + 18, 30, color, color);
            this.fillGradient(baseX - 2, 29, baseX + 18, 30, color, color);
        }
        RealmsScreen.bind((String)INVITE_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        RealmsScreen.blit((int)baseX, (int)6, (float)(hovering ? 16.0f : 0.0f), (float)0.0f, (int)15, (int)25, (float)31.0f, (float)25.0f);
        GL11.glPopMatrix();
        if (pendingInvitesCount != 0) {
            int spritePos = (Math.min(pendingInvitesCount, 6) - 1) * 8;
            int yOff = (int)(Math.max(0.0f, Math.max(RealmsMth.sin((float)((float)(10 + this.animTick) * 0.57f)), RealmsMth.cos((float)((float)this.animTick * 0.35f)))) * -6.0f);
            RealmsScreen.bind((String)INVITATION_ICONS_LOCATION);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            RealmsScreen.blit((int)(baseX + 4), (int)(16 + yOff), (float)spritePos, (float)0.0f, (int)8, (int)8, (float)48.0f, (float)8.0f);
            GL11.glPopMatrix();
        }
        boolean bl = renderToolTip = hovering || pendingInvitesCount != 0;
        if (renderToolTip) {
            int rx = xm + 12;
            int ry = ym - 12;
            if (!hovering) {
                rx = baseX + 22;
                ry = 12;
            }
            String message = pendingInvitesCount != 0 ? RealmsMainScreen.getLocalizedString((String)"mco.invites.pending") : RealmsMainScreen.getLocalizedString((String)"mco.invites.nopending");
            int width = this.fontWidth(message);
            this.fillGradient(rx - 3, ry - 3, rx + width + 3, ry + 8 + 3, -1073741824, -1073741824);
            this.fontDrawShadow(message, rx, ry, -1);
        }
    }

    private boolean inPendingInvitationArea(int xm, int ym) {
        int x1 = this.width() / 2 + 50;
        int x2 = this.width() / 2 + 66;
        int y1 = 13;
        int y2 = 27;
        return x1 <= xm && xm <= x2 && y1 <= ym && ym <= y2;
    }

    private void play(long serverId) {
        RealmsServer server = this.findServer(serverId);
        if (server != null) {
            this.stopRealmsFetcherAndPinger();
            LongRunningMcoTaskScreen longRunningMcoTaskScreen = new LongRunningMcoTaskScreen(this, new RealmsConnectTask(this, server));
            longRunningMcoTaskScreen.start();
            Realms.setScreen((RealmsScreen)longRunningMcoTaskScreen);
        }
    }

    private boolean isSelfOwnedServer(RealmsServer serverData) {
        return serverData.owner != null && serverData.owner.equals(Realms.getName());
    }

    private boolean isSelfOwnedNonExpiredServer(RealmsServer serverData) {
        return serverData.owner != null && serverData.owner.equals(Realms.getName()) && !serverData.expired;
    }

    private void drawExpired(int x, int y, int xm, int ym) {
        RealmsScreen.bind((String)EXPIRED_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        RealmsScreen.blit((int)(x * 2), (int)(y * 2), (float)0.0f, (float)0.0f, (int)15, (int)15, (float)15.0f, (float)15.0f);
        GL11.glPopMatrix();
        if (xm >= x && xm <= x + 9 && ym >= y && ym <= y + 9 && ym < this.height() - 64 && ym > 32) {
            this.toolTip = RealmsMainScreen.getLocalizedString((String)"mco.selectServer.expired");
        }
    }

    private void drawExpiring(int x, int y, int xm, int ym, int daysLeft) {
        if (this.animTick % 20 < 10) {
            RealmsScreen.bind((String)ON_ICON_LOCATION);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            RealmsScreen.blit((int)(x * 2), (int)(y * 2), (float)0.0f, (float)0.0f, (int)15, (int)15, (float)15.0f, (float)15.0f);
            GL11.glPopMatrix();
        }
        if (xm >= x && xm <= x + 9 && ym >= y && ym <= y + 9 && ym < this.height() - 64 && ym > 32) {
            this.toolTip = daysLeft == 0 ? RealmsMainScreen.getLocalizedString((String)"mco.selectServer.expires.soon") : (daysLeft == 1 ? RealmsMainScreen.getLocalizedString((String)"mco.selectServer.expires.day") : RealmsMainScreen.getLocalizedString((String)"mco.selectServer.expires.days", (Object[])new Object[]{daysLeft}));
        }
    }

    private void drawOpen(int x, int y, int xm, int ym) {
        RealmsScreen.bind((String)ON_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        RealmsScreen.blit((int)(x * 2), (int)(y * 2), (float)0.0f, (float)0.0f, (int)15, (int)15, (float)15.0f, (float)15.0f);
        GL11.glPopMatrix();
        if (xm >= x && xm <= x + 9 && ym >= y && ym <= y + 9 && ym < this.height() - 64 && ym > 32) {
            this.toolTip = RealmsMainScreen.getLocalizedString((String)"mco.selectServer.open");
        }
    }

    private void drawClose(int x, int y, int xm, int ym) {
        RealmsScreen.bind((String)OFF_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        RealmsScreen.blit((int)(x * 2), (int)(y * 2), (float)0.0f, (float)0.0f, (int)15, (int)15, (float)15.0f, (float)15.0f);
        GL11.glPopMatrix();
        if (xm >= x && xm <= x + 9 && ym >= y && ym <= y + 9 && ym < this.height() - 64 && ym > 32) {
            this.toolTip = RealmsMainScreen.getLocalizedString((String)"mco.selectServer.closed");
        }
    }

    private void drawLocked(int x, int y, int xm, int ym) {
        RealmsScreen.bind((String)OFF_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        RealmsScreen.blit((int)(x * 2), (int)(y * 2), (float)0.0f, (float)0.0f, (int)15, (int)15, (float)15.0f, (float)15.0f);
        GL11.glPopMatrix();
        if (xm >= x && xm <= x + 9 && ym >= y && ym <= y + 9 && ym < this.height() - 64 && ym > 32) {
            this.toolTip = RealmsMainScreen.getLocalizedString((String)"mco.selectServer.locked");
        }
    }

    protected void renderMousehoverTooltip(String msg, int x, int y) {
        if (msg == null) {
            return;
        }
        int rx = x + 12;
        int ry = y - 12;
        int width = this.fontWidth(msg);
        this.fillGradient(rx - 3, ry - 3, rx + width + 3, ry + 8 + 3, -1073741824, -1073741824);
        this.fontDrawShadow(msg, rx, ry, -1);
    }

    private void renderLink(int xm, int ym) {
        String text = RealmsMainScreen.getLocalizedString((String)"mco.selectServer.whatisrealms");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        int linkColor = 0x3366BB;
        int hoverColor = 7107012;
        int textWidth = this.fontWidth(text);
        int leftPadding = 10;
        int topPadding = 12;
        int x1 = leftPadding;
        int x2 = x1 + textWidth + 1;
        int y1 = topPadding;
        int y2 = y1 + this.fontLineHeight();
        GL11.glTranslatef((float)x1, (float)y1, (float)0.0f);
        if (x1 <= xm && xm <= x2 && y1 <= ym && ym <= y2) {
            this.onLink = true;
            this.drawString(text, 0, 0, hoverColor);
        } else {
            this.onLink = false;
            this.drawString(text, 0, 0, linkColor);
        }
        GL11.glPopMatrix();
    }

    private void renderStage() {
        String text = "STAGE!";
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.width() / 2 - 25), (float)20.0f, (float)0.0f);
        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        this.drawString(text, 0, 0, -256);
        GL11.glPopMatrix();
    }

    static {
        realmsGenericErrorScreen = null;
        regionsPinged = false;
        String version = RealmsVersion.getVersion();
        if (version != null) {
            LOGGER.info("Realms library version == " + version);
        }
    }

    private class ServerSelectionList
    extends RealmsScrolledSelectionList {
        public ServerSelectionList() {
            super(RealmsMainScreen.this.width(), RealmsMainScreen.this.height(), 32, RealmsMainScreen.this.height() - 64, 36);
        }

        public int getItemCount() {
            return RealmsMainScreen.this.realmsServers.size() + 1;
        }

        public void selectItem(int item, boolean doubleClick, int xMouse, int yMouse) {
            if (item >= RealmsMainScreen.this.realmsServers.size()) {
                return;
            }
            RealmsServer server = (RealmsServer)RealmsMainScreen.this.realmsServers.get(item);
            RealmsMainScreen.this.selectedServerId = server.id;
            if (server.state == RealmsServer.State.UNINITIALIZED) {
                RealmsMainScreen.this.stopRealmsFetcherAndPinger();
                Realms.setScreen((RealmsScreen)new CreateRealmsWorldScreen(server.id, RealmsMainScreen.this));
            }
            RealmsMainScreen.this.configureButton.active(overrideConfigure || RealmsMainScreen.this.isSelfOwnedServer(server) && server.state != RealmsServer.State.ADMIN_LOCK);
            RealmsMainScreen.this.leaveButton.active(!RealmsMainScreen.this.isSelfOwnedServer(server));
            RealmsMainScreen.this.playButton.active(server.state == RealmsServer.State.OPEN && !server.expired);
            if (doubleClick && RealmsMainScreen.this.playButton.active()) {
                RealmsMainScreen.this.play(RealmsMainScreen.this.selectedServerId);
            }
        }

        public boolean isSelectedItem(int item) {
            return item == RealmsMainScreen.this.findIndex(RealmsMainScreen.this.selectedServerId);
        }

        public int getMaxPosition() {
            return this.getItemCount() * 36;
        }

        public void renderBackground() {
            RealmsMainScreen.this.renderBackground();
        }

        protected void renderItem(int i, int x, int y, int h, Tezzelator t, int mouseX, int mouseY) {
            if (i < RealmsMainScreen.this.realmsServers.size()) {
                this.renderMcoServerItem(i, x, y);
            }
        }

        private void renderMcoServerItem(int i, int x, int y) {
            final RealmsServer serverData = (RealmsServer)RealmsMainScreen.this.realmsServers.get(i);
            int nameColor = -1;
            if (RealmsMainScreen.this.isSelfOwnedServer(serverData)) {
                nameColor = -8388737;
            }
            if (serverData.state == RealmsServer.State.UNINITIALIZED) {
                RealmsScreen.bind((String)RealmsMainScreen.WORLDICON_LOCATION);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3008);
                GL11.glPushMatrix();
                RealmsScreen.blit((int)(x + 10), (int)(y + 6), (float)0.0f, (float)0.0f, (int)40, (int)20, (float)40.0f, (float)20.0f);
                GL11.glPopMatrix();
                float scale = 0.5f + (1.0f + RealmsMth.sin((float)((float)RealmsMainScreen.this.animTick * 0.25f))) * 0.25f;
                int textColor = 0xFF000000 | (int)(127.0f * scale) << 16 | (int)(255.0f * scale) << 8 | (int)(127.0f * scale);
                RealmsMainScreen.this.drawCenteredString(RealmsScreen.getLocalizedString((String)"mco.selectServer.uninitialized"), x + 10 + 40 + 75, y + 12, textColor);
                return;
            }
            if (serverData.shouldPing(Realms.currentTimeMillis())) {
                serverData.serverPing.lastPingSnapshot = Realms.currentTimeMillis();
                THREAD_POOL.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            statusPinger.pingServer(serverData.ip, serverData.serverPing);
                        }
                        catch (UnknownHostException e) {
                            LOGGER.error("Pinger: Could not resolve host");
                        }
                    }
                });
            }
            RealmsMainScreen.this.drawString(serverData.getName(), x + 2, y + 1, nameColor);
            int dx = 207;
            int dy = 1;
            if (serverData.expired) {
                RealmsMainScreen.this.drawExpired(x + dx, y + dy, this.xm(), this.ym());
            } else if (serverData.state == RealmsServer.State.CLOSED) {
                RealmsMainScreen.this.drawClose(x + dx, y + dy, this.xm(), this.ym());
            } else if (RealmsMainScreen.this.isSelfOwnedServer(serverData) && serverData.daysLeft < 7) {
                this.showStatus(x - 14, y, serverData);
                RealmsMainScreen.this.drawExpiring(x + dx, y + dy, this.xm(), this.ym(), serverData.daysLeft);
            } else if (serverData.state == RealmsServer.State.OPEN) {
                RealmsMainScreen.this.drawOpen(x + dx, y + dy, this.xm(), this.ym());
                this.showStatus(x - 14, y, serverData);
            } else if (serverData.state == RealmsServer.State.ADMIN_LOCK) {
                RealmsMainScreen.this.drawLocked(x + dx, y + dy, this.xm(), this.ym());
            }
            String noPlayers = "0";
            if (!serverData.serverPing.nrOfPlayers.equals(noPlayers)) {
                String coloredNumPlayers = (Object)((Object)ChatFormatting.GRAY) + "" + serverData.serverPing.nrOfPlayers;
                RealmsMainScreen.this.drawString(coloredNumPlayers, x + 200 - RealmsMainScreen.this.fontWidth(coloredNumPlayers), y + 1, 0x808080);
            }
            if (serverData.worldType.equals((Object)RealmsServer.WorldType.MINIGAME)) {
                int motdColor = 9206892;
                if (RealmsMainScreen.this.animTick % 10 < 5) {
                    motdColor = 0xCCAC5C;
                }
                String miniGameStr = RealmsScreen.getLocalizedString((String)"mco.selectServer.minigame") + " ";
                int mgWidth = RealmsMainScreen.this.fontWidth(miniGameStr);
                RealmsMainScreen.this.drawString(miniGameStr, x + 2, y + 12, motdColor);
                RealmsMainScreen.this.drawString(serverData.getMotd(), x + 2 + mgWidth, y + 12, 0x6C6C6C);
            } else {
                RealmsMainScreen.this.drawString(serverData.getMotd(), x + 2, y + 12, 0x6C6C6C);
            }
            RealmsMainScreen.this.drawString(serverData.owner, x + 2, y + 12 + 11, 0x4C4C4C);
            RealmsScreen.bindFace((String)serverData.ownerUUID, (String)serverData.owner);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RealmsScreen.blit((int)(x - 36), (int)y, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)32, (int)32, (float)64.0f, (float)64.0f);
            RealmsScreen.blit((int)(x - 36), (int)y, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)32, (int)32, (float)64.0f, (float)64.0f);
        }

        private void showStatus(int x, int y, RealmsServer serverData) {
            if (serverData.ip == null) {
                return;
            }
            if (serverData.status != null) {
                RealmsMainScreen.this.drawString(serverData.status, x + 215 - RealmsMainScreen.this.fontWidth(serverData.status), y + 1, 0x808080);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RealmsScreen.bind((String)"textures/gui/icons.png");
        }
    }
}

