/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.common.util.EnumHelper;

public class BiomeManager {
    private static TrackedList<BiomeEntry>[] biomes = BiomeManager.setupBiomes();
    @Deprecated
    public static List<BiomeEntry> desertBiomes = biomes[BiomeType.DESERT.ordinal()];
    @Deprecated
    public static List<BiomeEntry> warmBiomes = biomes[BiomeType.WARM.ordinal()];
    @Deprecated
    public static List<BiomeEntry> coolBiomes = biomes[BiomeType.COOL.ordinal()];
    @Deprecated
    public static List<BiomeEntry> icyBiomes = biomes[BiomeType.ICY.ordinal()];
    private static boolean isModded = false;
    public static List<ahu> oceanBiomes = new ArrayList<ahu>();
    public static ArrayList<ahu> strongHoldBiomes = new ArrayList();
    public static ArrayList<ahu> strongHoldBiomesBlackList = new ArrayList();

    private static TrackedList<BiomeEntry>[] setupBiomes() {
        TrackedList[] currentBiomes = new TrackedList[BiomeType.values().length];
        ArrayList<BiomeEntry> list = new ArrayList<BiomeEntry>();
        list.add(new BiomeEntry(ahu.s, 10));
        list.add(new BiomeEntry(ahu.R, 10));
        list.add(new BiomeEntry(ahu.r, 10));
        list.add(new BiomeEntry(ahu.p, 10));
        list.add(new BiomeEntry(ahu.P, 10));
        list.add(new BiomeEntry(ahu.u, 10));
        currentBiomes[BiomeType.WARM.ordinal()] = new TrackedList(list);
        list.clear();
        list.add(new BiomeEntry(ahu.s, 10));
        list.add(new BiomeEntry(ahu.r, 10));
        list.add(new BiomeEntry(ahu.t, 10));
        list.add(new BiomeEntry(ahu.p, 10));
        currentBiomes[BiomeType.COOL.ordinal()] = new TrackedList(list);
        list.clear();
        list.add(new BiomeEntry(ahu.A, 30));
        list.add(new BiomeEntry(ahu.S, 10));
        currentBiomes[BiomeType.ICY.ordinal()] = new TrackedList(list);
        list.clear();
        return currentBiomes;
    }

    public static void addVillageBiome(ahu biome, boolean canSpawn) {
        if (!avn.e.contains(biome)) {
            ArrayList<ahu> biomes = new ArrayList<ahu>(avn.e);
            biomes.add(biome);
            avn.e = biomes;
        }
    }

    public static void removeVillageBiome(ahu biome) {
        if (avn.e.contains(biome)) {
            ArrayList biomes = new ArrayList(avn.e);
            biomes.remove(biome);
            avn.e = biomes;
        }
    }

    public static void addStrongholdBiome(ahu biome) {
        if (!strongHoldBiomes.contains(biome)) {
            strongHoldBiomes.add(biome);
        }
    }

    public static void removeStrongholdBiome(ahu biome) {
        if (!strongHoldBiomesBlackList.contains(biome)) {
            strongHoldBiomesBlackList.add(biome);
        }
    }

    public static void addSpawnBiome(ahu biome) {
        if (!aib.allowedBiomes.contains(biome)) {
            aib.allowedBiomes.add(biome);
        }
    }

    public static void removeSpawnBiome(ahu biome) {
        if (aib.allowedBiomes.contains(biome)) {
            aib.allowedBiomes.remove(biome);
        }
    }

    public static void addBiome(BiomeType type, BiomeEntry entry) {
        TrackedList<BiomeEntry> list;
        isModded = true;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null) {
            list.add(entry);
        }
    }

    public static void removeBiome(BiomeType type, BiomeEntry entry) {
        TrackedList<BiomeEntry> list;
        isModded = true;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null && list.contains((Object)entry)) {
            list.remove((Object)entry);
        }
    }

    public static ImmutableList<BiomeEntry> getBiomes(BiomeType type) {
        int idx = type.ordinal();
        TrackedList<BiomeEntry> list = idx > biomes.length ? null : biomes[idx];
        return list != null ? ImmutableList.copyOf(list) : null;
    }

    public static boolean isTypeListModded(BiomeType type) {
        TrackedList<BiomeEntry> list;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null) {
            return list.isModded();
        }
        return false;
    }

    static /* synthetic */ TrackedList[] access$002(TrackedList[] x0) {
        biomes = x0;
        return x0;
    }

    static {
        oceanBiomes.add(ahu.o);
        oceanBiomes.add(ahu.M);
        oceanBiomes.add(ahu.y);
    }

    private static class TrackedList<E>
    extends ArrayList<E> {
        private boolean isModded = false;

        public TrackedList(Collection<? extends E> c) {
            super(c);
        }

        @Override
        public E set(int index, E element) {
            this.isModded = true;
            return super.set(index, element);
        }

        @Override
        public boolean add(E e) {
            this.isModded = true;
            return super.add(e);
        }

        @Override
        public void add(int index, E element) {
            this.isModded = true;
            super.add(index, element);
        }

        @Override
        public E remove(int index) {
            this.isModded = true;
            return super.remove(index);
        }

        @Override
        public boolean remove(Object o) {
            this.isModded = true;
            return super.remove(o);
        }

        @Override
        public void clear() {
            this.isModded = true;
            super.clear();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            this.isModded = true;
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.isModded = true;
            return super.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            this.isModded = true;
            return super.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            this.isModded = true;
            return super.retainAll(c);
        }

        public boolean isModded() {
            return this.isModded;
        }
    }

    public static class BiomeEntry
    extends qw {
        public final ahu biome;

        public BiomeEntry(ahu biome, int weight) {
            super(weight);
            this.biome = biome;
        }
    }

    public static enum BiomeType {
        DESERT,
        WARM,
        COOL,
        ICY;


        public static BiomeType getType(String name) {
            name = name.toUpperCase();
            for (BiomeType t : BiomeType.values()) {
                if (!t.name().equals(name)) continue;
                return t;
            }
            BiomeType ret = EnumHelper.addEnum(BiomeType.class, name, BiomeType.class);
            if (ret.ordinal() >= biomes.length) {
                BiomeManager.access$002(Arrays.copyOf(biomes, ret.ordinal()));
            }
            return ret;
        }
    }
}

