/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.time.FormatCache$MultipartKey;

abstract class FormatCache {
    private final ConcurrentMap cInstanceCache = new ConcurrentHashMap(7);
    private final ConcurrentMap cDateTimeInstanceCache = new ConcurrentHashMap(7);

    FormatCache() {
    }

    public Format getInstance() {
        return this.getDateTimeInstance(3, 3, TimeZone.getDefault(), Locale.getDefault());
    }

    public Format getInstance(String object, TimeZone timeZone, Locale locale) {
        FormatCache$MultipartKey formatCache$MultipartKey;
        Object object2;
        if (object == null) {
            throw new NullPointerException("pattern must not be null");
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((object2 = (Format)this.cInstanceCache.get(formatCache$MultipartKey = new FormatCache$MultipartKey(object, timeZone, locale))) == null && (object = this.cInstanceCache.putIfAbsent(formatCache$MultipartKey, object2 = this.createInstance((String)object, timeZone, locale))) != null) {
            object2 = object;
        }
        return object2;
    }

    protected abstract Format createInstance(String var1, TimeZone var2, Locale var3);

    public Format getDateTimeInstance(Integer object, Integer n2, TimeZone timeZone, Locale locale) {
        FormatCache$MultipartKey formatCache$MultipartKey;
        Object object2;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((object2 = (String)this.cDateTimeInstanceCache.get(formatCache$MultipartKey = new FormatCache$MultipartKey(object, n2, locale))) == null) {
            try {
                object = object == null ? DateFormat.getTimeInstance(n2, locale) : (n2 == null ? DateFormat.getDateInstance((Integer)object, locale) : DateFormat.getDateTimeInstance((Integer)object, n2, locale));
                object2 = ((SimpleDateFormat)object).toPattern();
                object = this.cDateTimeInstanceCache.putIfAbsent(formatCache$MultipartKey, object2);
                if (object != null) {
                    object2 = object;
                }
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("No date time pattern for locale: " + locale);
            }
        }
        return this.getInstance((String)object2, timeZone, locale);
    }
}

