/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils$Token;

public class DurationFormatUtils {
    public static final String ISO_EXTENDED_FORMAT_PATTERN = "'P'yyyy'Y'M'M'd'DT'H'H'm'M's.S'S'";
    private static Object y = "y";
    private static Object M = "M";
    private static Object d = "d";
    private static Object H = "H";
    private static Object m = "m";
    private static Object s = "s";
    private static Object S = "S";

    public static String formatDurationHMS(long l2) {
        return DurationFormatUtils.formatDuration(l2, "H:mm:ss.SSS");
    }

    public static String formatDurationISO(long l2) {
        return DurationFormatUtils.formatDuration(l2, ISO_EXTENDED_FORMAT_PATTERN, false);
    }

    public static String formatDuration(long l2, String string) {
        return DurationFormatUtils.formatDuration(l2, string, true);
    }

    public static String formatDuration(long l2, String durationFormatUtils$TokenArray, boolean bl) {
        durationFormatUtils$TokenArray = DurationFormatUtils.lexx((String)durationFormatUtils$TokenArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (DurationFormatUtils$Token.a(durationFormatUtils$TokenArray, d)) {
            n2 = (int)(l2 / 86400000L);
            l2 -= (long)n2 * 86400000L;
        }
        if (DurationFormatUtils$Token.a(durationFormatUtils$TokenArray, H)) {
            n3 = (int)(l2 / 3600000L);
            l2 -= (long)n3 * 3600000L;
        }
        if (DurationFormatUtils$Token.a(durationFormatUtils$TokenArray, m)) {
            n4 = (int)(l2 / 60000L);
            l2 -= (long)n4 * 60000L;
        }
        if (DurationFormatUtils$Token.a(durationFormatUtils$TokenArray, s)) {
            n5 = (int)(l2 / 1000L);
            l2 -= (long)n5 * 1000L;
        }
        if (DurationFormatUtils$Token.a(durationFormatUtils$TokenArray, S)) {
            n6 = (int)l2;
        }
        return DurationFormatUtils.format(durationFormatUtils$TokenArray, 0, 0, n2, n3, n4, n5, n6, bl);
    }

    public static String formatDurationWords(long l2, boolean bl, boolean bl2) {
        String string;
        String string2 = DurationFormatUtils.formatDuration(l2, "d' days 'H' hours 'm' minutes 's' seconds'");
        if (bl) {
            string2 = " " + string2;
            string = StringUtils.replaceOnce(string2, " 0 days", "");
            if (string.length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 hours", "")).length() != string2.length()) {
                string2 = string;
                string2 = string = StringUtils.replaceOnce(string2, " 0 minutes", "");
                if (string.length() != string2.length()) {
                    string2 = StringUtils.replaceOnce(string, " 0 seconds", "");
                }
            }
            if (string2.length() != 0) {
                string2 = string2.substring(1);
            }
        }
        if (bl2 && (string = StringUtils.replaceOnce(string2, " 0 seconds", "")).length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 minutes", "")).length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 hours", "")).length() != string2.length()) {
            string2 = StringUtils.replaceOnce(string, " 0 days", "");
        }
        string2 = " " + string2;
        string2 = StringUtils.replaceOnce(string2, " 1 seconds", " 1 second");
        string2 = StringUtils.replaceOnce(string2, " 1 minutes", " 1 minute");
        string2 = StringUtils.replaceOnce(string2, " 1 hours", " 1 hour");
        string2 = StringUtils.replaceOnce(string2, " 1 days", " 1 day");
        return string2.trim();
    }

    public static String formatPeriodISO(long l2, long l3) {
        return DurationFormatUtils.formatPeriod(l2, l3, ISO_EXTENDED_FORMAT_PATTERN, false, TimeZone.getDefault());
    }

    public static String formatPeriod(long l2, long l3, String string) {
        return DurationFormatUtils.formatPeriod(l2, l3, string, true, TimeZone.getDefault());
    }

    public static String formatPeriod(long l2, long l3, String durationFormatUtils$TokenArray, boolean bl, TimeZone timeZone) {
        durationFormatUtils$TokenArray = DurationFormatUtils.lexx((String)durationFormatUtils$TokenArray);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(new Date(l2));
        Calendar calendar2 = Calendar.getInstance(timeZone);
        calendar2.setTime(new Date(l3));
        int n2 = calendar2.get(14) - calendar.get(14);
        int n3 = calendar2.get(13) - calendar.get(13);
        int n4 = calendar2.get(12) - calendar.get(12);
        int n5 = calendar2.get(11) - calendar.get(11);
        int n6 = calendar2.get(5) - calendar.get(5);
        int n7 = calendar2.get(2) - calendar.get(2);
        int n8 = calendar2.get(1) - calendar.get(1);
        while (n2 < 0) {
            n2 += 1000;
            --n3;
        }
        while (n3 < 0) {
            n3 += 60;
            --n4;
        }
        while (n4 < 0) {
            n4 += 60;
            --n5;
        }
        while (n5 < 0) {
            n5 += 24;
            --n6;
        }
        if (DurationFormatUtils$Token.a(durationFormatUtils$TokenArray, M)) {
            while (n6 < 0) {
                n6 += calendar.getActualMaximum(5);
                --n7;
                calendar.add(2, 1);
            }
            while (n7 < 0) {
                n7 += 12;
                --n8;
            }
            if (!DurationFormatUtils$Token.a(durationFormatUtils$TokenArray, y) && n8 != 0) {
                while (n8 != 0) {
                    n7 += n8 * 12;
                    n8 = 0;
                }
            }
        } else {
            if (!DurationFormatUtils$Token.a(durationFormatUtils$TokenArray, y)) {
                n8 = calendar2.get(1);
                if (n7 < 0) {
                    --n8;
                }
                while (calendar.get(1) != n8) {
                    n6 += calendar.getActualMaximum(6) - calendar.get(6);
                    if (calendar instanceof GregorianCalendar && calendar.get(2) == 1 && calendar.get(5) == 29) {
                        ++n6;
                    }
                    calendar.add(1, 1);
                    n6 += calendar.get(6);
                }
                n8 = 0;
            }
            while (calendar.get(2) != calendar2.get(2)) {
                n6 += calendar.getActualMaximum(5);
                calendar.add(2, 1);
            }
            n7 = 0;
            while (n6 < 0) {
                n6 += calendar.getActualMaximum(5);
                --n7;
                calendar.add(2, 1);
            }
        }
        if (!DurationFormatUtils$Token.a(durationFormatUtils$TokenArray, d)) {
            n5 += n6 * 24;
            n6 = 0;
        }
        if (!DurationFormatUtils$Token.a(durationFormatUtils$TokenArray, H)) {
            n4 += n5 * 60;
            n5 = 0;
        }
        if (!DurationFormatUtils$Token.a(durationFormatUtils$TokenArray, m)) {
            n3 += n4 * 60;
            n4 = 0;
        }
        if (!DurationFormatUtils$Token.a(durationFormatUtils$TokenArray, s)) {
            n2 += n3 * 1000;
            n3 = 0;
        }
        return DurationFormatUtils.format(durationFormatUtils$TokenArray, n8, n7, n6, n5, n4, n3, n2, bl);
    }

    private static String format(DurationFormatUtils$Token[] durationFormatUtils$TokenArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        for (DurationFormatUtils$Token durationFormatUtils$Token : durationFormatUtils$TokenArray) {
            Object object = durationFormatUtils$Token.c();
            int n9 = durationFormatUtils$Token.b();
            if (object instanceof StringBuffer) {
                stringBuffer.append(object.toString());
                continue;
            }
            if (object == y) {
                stringBuffer.append(bl ? StringUtils.leftPad(Integer.toString(n2), n9, '0') : Integer.toString(n2));
            } else if (object == M) {
                stringBuffer.append(bl ? StringUtils.leftPad(Integer.toString(n3), n9, '0') : Integer.toString(n3));
            } else if (object == d) {
                stringBuffer.append(bl ? StringUtils.leftPad(Integer.toString(n4), n9, '0') : Integer.toString(n4));
            } else if (object == H) {
                stringBuffer.append(bl ? StringUtils.leftPad(Integer.toString(n5), n9, '0') : Integer.toString(n5));
            } else if (object == m) {
                stringBuffer.append(bl ? StringUtils.leftPad(Integer.toString(n6), n9, '0') : Integer.toString(n6));
            } else {
                if (object == s) {
                    stringBuffer.append(bl ? StringUtils.leftPad(Integer.toString(n7), n9, '0') : Integer.toString(n7));
                    bl2 = true;
                    continue;
                }
                if (object != S) continue;
                if (bl2) {
                    String string = bl ? StringUtils.leftPad(Integer.toString(n8), n9, '0') : Integer.toString(n8 += 1000);
                    stringBuffer.append(string.substring(1));
                } else {
                    stringBuffer.append(bl ? StringUtils.leftPad(Integer.toString(n8), n9, '0') : Integer.toString(n8));
                }
            }
            bl2 = false;
        }
        return stringBuffer.toString();
    }

    private static DurationFormatUtils$Token[] lexx(String object) {
        object = ((String)object).toCharArray();
        ArrayList<Object> arrayList = new ArrayList<Object>(((Object)object).length);
        boolean bl = false;
        Object object2 = null;
        Object object3 = null;
        for (Object object4 : object) {
            if (bl && object4 != 39) {
                ((StringBuffer)object2).append((char)object4);
                continue;
            }
            Object object5 = null;
            switch (object4) {
                case 39: {
                    if (bl) {
                        object2 = null;
                        bl = false;
                        break;
                    }
                    object2 = new StringBuffer();
                    arrayList.add(new DurationFormatUtils$Token(object2));
                    bl = true;
                    break;
                }
                case 121: {
                    object5 = y;
                    break;
                }
                case 77: {
                    object5 = M;
                    break;
                }
                case 100: {
                    object5 = d;
                    break;
                }
                case 72: {
                    object5 = H;
                    break;
                }
                case 109: {
                    object5 = m;
                    break;
                }
                case 115: {
                    object5 = s;
                    break;
                }
                case 83: {
                    object5 = S;
                    break;
                }
                default: {
                    if (object2 == null) {
                        object2 = new StringBuffer();
                        arrayList.add(new DurationFormatUtils$Token(object2));
                    }
                    ((StringBuffer)object2).append((char)object4);
                }
            }
            if (object5 == null) continue;
            if (object3 != null && ((DurationFormatUtils$Token)object3).c() == object5) {
                ((DurationFormatUtils$Token)object3).a();
            } else {
                object2 = new DurationFormatUtils$Token(object5);
                arrayList.add(object2);
                object3 = object2;
            }
            object2 = null;
        }
        return arrayList.toArray(new DurationFormatUtils$Token[arrayList.size()]);
    }
}

