/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text.translate;

import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;

public class LookupTranslator
extends CharSequenceTranslator {
    private final HashMap lookupMap = new HashMap();
    private final int shortest;
    private final int longest;

    public LookupTranslator(CharSequence[] ... charSequenceArray) {
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        if (charSequenceArray != null) {
            for (CharSequence[] charSequenceArray2 : charSequenceArray) {
                this.lookupMap.put(charSequenceArray2[0], charSequenceArray2[1]);
                int n4 = charSequenceArray2[0].length();
                if (n4 < n2) {
                    n2 = n4;
                }
                if (n4 <= n3) continue;
                n3 = n4;
            }
        }
        this.shortest = n2;
        this.longest = n3;
    }

    @Override
    public int translate(CharSequence charSequence, int n2, Writer writer) {
        int n3 = this.longest;
        if (n2 + this.longest > charSequence.length()) {
            n3 = charSequence.length() - n2;
        }
        while (n3 >= this.shortest) {
            CharSequence charSequence2 = charSequence.subSequence(n2, n2 + n3);
            if ((charSequence2 = (CharSequence)this.lookupMap.get(charSequence2)) != null) {
                writer.write(((Object)charSequence2).toString());
                return n3;
            }
            --n3;
        }
        return 0;
    }
}

