/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MemberUtils;

public class MethodUtils {
    public static Object invokeMethod(Object object, String string, Object ... objectArray) {
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int n2 = objectArray.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        return MethodUtils.invokeMethod(object, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray, Class[] object2) {
        if (object2 == null) {
            object2 = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if ((object2 = MethodUtils.getMatchingAccessibleMethod(object.getClass(), string, (Class[])object2)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return ((Method)object2).invoke(object, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object ... objectArray) {
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int n2 = objectArray.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        return MethodUtils.invokeExactMethod(object, string, objectArray, classArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray, Class[] object2) {
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (object2 == null) {
            object2 = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if ((object2 = MethodUtils.getAccessibleMethod(object.getClass(), string, (Class[])object2)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return ((Method)object2).invoke(object, objectArray);
    }

    public static Object invokeExactStaticMethod(Class clazz, String string, Object[] objectArray, Class[] object) {
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (object == null) {
            object = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if ((object = MethodUtils.getAccessibleMethod(clazz, string, (Class[])object)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on class: " + clazz.getName());
        }
        return ((Method)object).invoke(null, objectArray);
    }

    public static Object invokeStaticMethod(Class clazz, String string, Object ... objectArray) {
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int n2 = objectArray.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        return MethodUtils.invokeStaticMethod(clazz, string, objectArray, classArray);
    }

    public static Object invokeStaticMethod(Class clazz, String string, Object[] objectArray, Class[] object) {
        if (object == null) {
            object = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if ((object = MethodUtils.getMatchingAccessibleMethod(clazz, string, (Class[])object)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on class: " + clazz.getName());
        }
        return ((Method)object).invoke(null, objectArray);
    }

    public static Object invokeExactStaticMethod(Class clazz, String string, Object ... objectArray) {
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int n2 = objectArray.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        return MethodUtils.invokeExactStaticMethod(clazz, string, objectArray, classArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class ... classArray) {
        try {
            return MethodUtils.getAccessibleMethod(clazz.getMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        Class[] classArray;
        if (!MemberUtils.a(method)) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        String string = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, string, classArray = method.getParameterTypes())) == null) {
            method = MethodUtils.getAccessibleMethodFromSuperclass(clazz, string, classArray);
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class clazz, String string, Class ... classArray) {
        for (clazz = clazz.getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!Modifier.isPublic(clazz.getModifiers())) continue;
            try {
                return clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String string, Class ... classArray) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] classArray2 = clazz.getInterfaces();
            for (int i2 = 0; i2 < classArray2.length; ++i2) {
                if (!Modifier.isPublic(classArray2[i2].getModifiers())) continue;
                try {
                    method = classArray2[i2].getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(classArray2[i2], string, classArray)) != null) break;
            }
            clazz = clazz.getSuperclass();
        }
        return method;
    }

    public static Method getMatchingAccessibleMethod(Class methodArray, String string, Class ... classArray) {
        try {
            Method method = methodArray.getMethod(string, classArray);
            MemberUtils.a(method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method method = null;
            Method[] methodArray2 = methodArray.getMethods();
            methodArray = methodArray2;
            methodArray = methodArray2;
            int n2 = methodArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Method method2 = methodArray[i2];
                if (!method2.getName().equals(string) || !ClassUtils.isAssignable(classArray, (Class[])method2.getParameterTypes(), true) || (method2 = MethodUtils.getAccessibleMethod(method2)) == null || method != null && MemberUtils.a(method2.getParameterTypes(), method.getParameterTypes(), classArray) >= 0) continue;
                method = method2;
            }
            if (method != null) {
                MemberUtils.a(method);
            }
            return method;
        }
    }
}

