/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.Mutable;

public class MutableShort
extends Number
implements Comparable,
Mutable {
    private static final long serialVersionUID = -2135791679L;
    private short value;

    public MutableShort() {
    }

    public MutableShort(short s) {
        this.value = s;
    }

    public MutableShort(Number number) {
        this.value = number.shortValue();
    }

    public MutableShort(String string) {
        this.value = Short.parseShort(string);
    }

    @Override
    public Short getValue() {
        return this.value;
    }

    public void setValue(short s) {
        this.value = s;
    }

    public void setValue(Number number) {
        this.value = number.shortValue();
    }

    public void increment() {
        this.value = (short)(this.value + 1);
    }

    public void decrement() {
        this.value = (short)(this.value - 1);
    }

    public void add(short s) {
        this.value = (short)(this.value + s);
    }

    public void add(Number number) {
        this.value = (short)(this.value + number.shortValue());
    }

    public void subtract(short s) {
        this.value = (short)(this.value - s);
    }

    public void subtract(Number number) {
        this.value = (short)(this.value - number.shortValue());
    }

    @Override
    public final short shortValue() {
        return this.value;
    }

    @Override
    public final int intValue() {
        return this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    public Short toShort() {
        return this.shortValue();
    }

    public final boolean equals(Object object) {
        if (object instanceof MutableShort) {
            return this.value == ((MutableShort)object).shortValue();
        }
        return false;
    }

    public final int hashCode() {
        return this.value;
    }

    public int compareTo(MutableShort mutableShort) {
        short s = mutableShort.value;
        if (this.value < s) {
            return -1;
        }
        if (this.value == s) {
            return 0;
        }
        return 1;
    }

    public final String toString() {
        return String.valueOf(this.value);
    }
}

