/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class ExceptionUtils {
    private static final String[] CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};

    public static String[] getDefaultCauseMethodNames() {
        return (String[])ArrayUtils.clone(CAUSE_METHOD_NAMES);
    }

    public static Throwable getCause(Throwable throwable) {
        return ExceptionUtils.getCause(throwable, CAUSE_METHOD_NAMES);
    }

    public static Throwable getCause(Throwable throwable, String[] stringArray) {
        if (throwable == null) {
            return null;
        }
        if (stringArray == null) {
            stringArray = CAUSE_METHOD_NAMES;
        }
        for (String string : stringArray) {
            Throwable throwable2;
            if (string == null || (throwable2 = ExceptionUtils.getCauseUsingMethodName(throwable, string)) == null) continue;
            return throwable2;
        }
        return null;
    }

    public static Throwable getRootCause(Throwable object) {
        if ((object = ExceptionUtils.getThrowableList((Throwable)object)).size() < 2) {
            return null;
        }
        return (Throwable)object.get(object.size() - 1);
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String string) {
        Method method = null;
        try {
            method = throwable.getClass().getMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {}
        if (method != null && Throwable.class.isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return null;
    }

    public static int getThrowableCount(Throwable throwable) {
        return ExceptionUtils.getThrowableList(throwable).size();
    }

    public static Throwable[] getThrowables(Throwable object) {
        object = ExceptionUtils.getThrowableList((Throwable)object);
        return object.toArray(new Throwable[object.size()]);
    }

    public static List getThrowableList(Throwable throwable) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        while (throwable != null && !arrayList.contains(throwable)) {
            arrayList.add(throwable);
            throwable = ExceptionUtils.getCause(throwable);
        }
        return arrayList;
    }

    public static int indexOfThrowable(Throwable throwable, Class clazz) {
        return ExceptionUtils.indexOf(throwable, clazz, 0, false);
    }

    public static int indexOfThrowable(Throwable throwable, Class clazz, int n2) {
        return ExceptionUtils.indexOf(throwable, clazz, n2, false);
    }

    public static int indexOfType(Throwable throwable, Class clazz) {
        return ExceptionUtils.indexOf(throwable, clazz, 0, true);
    }

    public static int indexOfType(Throwable throwable, Class clazz, int n2) {
        return ExceptionUtils.indexOf(throwable, clazz, n2, true);
    }

    private static int indexOf(Throwable throwableArray, Class clazz, int n2, boolean bl) {
        if (throwableArray == null || clazz == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= (throwableArray = ExceptionUtils.getThrowables((Throwable)throwableArray)).length) {
            return -1;
        }
        if (bl) {
            while (n2 < throwableArray.length) {
                if (clazz.isAssignableFrom(throwableArray[n2].getClass())) {
                    return n2;
                }
                ++n2;
            }
        } else {
            while (n2 < throwableArray.length) {
                if (clazz.equals(throwableArray[n2].getClass())) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public static void printRootCauseStackTrace(Throwable throwable) {
        ExceptionUtils.printRootCauseStackTrace(throwable, System.err);
    }

    public static void printRootCauseStackTrace(Throwable stringArray, PrintStream printStream) {
        if (stringArray == null) {
            return;
        }
        if (printStream == null) {
            throw new IllegalArgumentException("The PrintStream must not be null");
        }
        String[] stringArray2 = ExceptionUtils.getRootCauseStackTrace((Throwable)stringArray);
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            printStream.println(string);
        }
        printStream.flush();
    }

    public static void printRootCauseStackTrace(Throwable stringArray, PrintWriter printWriter) {
        if (stringArray == null) {
            return;
        }
        if (printWriter == null) {
            throw new IllegalArgumentException("The PrintWriter must not be null");
        }
        String[] stringArray2 = ExceptionUtils.getRootCauseStackTrace((Throwable)stringArray);
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            printWriter.println(string);
        }
        printWriter.flush();
    }

    public static String[] getRootCauseStackTrace(Throwable throwableArray) {
        if (throwableArray == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        throwableArray = ExceptionUtils.getThrowables((Throwable)throwableArray);
        int n2 = throwableArray.length;
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = ExceptionUtils.getStackFrameList(throwableArray[n2 - 1]);
        int n3 = n2;
        while (--n3 >= 0) {
            List list2 = list;
            if (n3 != 0) {
                list = ExceptionUtils.getStackFrameList(throwableArray[n3 - 1]);
                ExceptionUtils.removeCommonFrames(list2, list);
            }
            if (n3 == n2 - 1) {
                arrayList.add(throwableArray[n3].toString());
            } else {
                arrayList.add(" [wrapped] " + throwableArray[n3].toString());
            }
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                arrayList.add((String)list2.get(i2));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void removeCommonFrames(List list, List list2) {
        if (list == null || list2 == null) {
            throw new IllegalArgumentException("The List must not be null");
        }
        int n2 = list.size() - 1;
        for (int i2 = list2.size() - 1; n2 >= 0 && i2 >= 0; --n2, --i2) {
            String string;
            String string2 = (String)list.get(n2);
            if (!string2.equals(string = (String)list2.get(i2))) continue;
            list.remove(n2);
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    public static String[] getStackFrames(Throwable object) {
        if (object == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        object = ExceptionUtils.getStackTrace((Throwable)object);
        Object object2 = SystemUtils.LINE_SEPARATOR;
        object = new StringTokenizer((String)object, (String)object2);
        object2 = new ArrayList();
        while (((StringTokenizer)object).hasMoreTokens()) {
            object2.add(((StringTokenizer)object).nextToken());
        }
        return object2.toArray(new String[object2.size()]);
    }

    private static String[] getStackFrames(String object) {
        Object object2 = SystemUtils.LINE_SEPARATOR;
        object = new StringTokenizer((String)object, (String)object2);
        object2 = new ArrayList();
        while (((StringTokenizer)object).hasMoreTokens()) {
            object2.add(((StringTokenizer)object).nextToken());
        }
        return object2.toArray(new String[object2.size()]);
    }

    private static List getStackFrameList(Throwable object) {
        object = ExceptionUtils.getStackTrace((Throwable)object);
        Object object2 = SystemUtils.LINE_SEPARATOR;
        object = new StringTokenizer((String)object, (String)object2);
        object2 = new ArrayList();
        boolean bl = false;
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string = ((StringTokenizer)object).nextToken();
            int n2 = string.indexOf("at");
            if (n2 != -1 && string.substring(0, n2).trim().length() == 0) {
                bl = true;
                object2.add(string);
                continue;
            }
            if (!bl) continue;
        }
        return object2;
    }

    public static String getMessage(Throwable object) {
        if (object == null) {
            return "";
        }
        String string = ClassUtils.getShortClassName(object, null);
        object = ((Throwable)object).getMessage();
        return string + ": " + StringUtils.defaultString((String)object);
    }

    public static String getRootCauseMessage(Throwable throwable) {
        Throwable throwable2 = ExceptionUtils.getRootCause(throwable);
        throwable2 = throwable2 == null ? throwable : throwable2;
        return ExceptionUtils.getMessage(throwable2);
    }
}

