/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultExceptionContext
implements Serializable,
ExceptionContext {
    private static final long serialVersionUID = 20110706L;
    private final List contextValues = new ArrayList();

    @Override
    public DefaultExceptionContext addContextValue(String string, Object object) {
        this.contextValues.add(new ImmutablePair(string, object));
        return this;
    }

    @Override
    public DefaultExceptionContext setContextValue(String string, Object object) {
        Iterator iterator = this.contextValues.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (!StringUtils.equals(string, (CharSequence)pair.getKey())) continue;
            iterator.remove();
        }
        this.addContextValue(string, object);
        return this;
    }

    @Override
    public List getContextValues(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Pair pair : this.contextValues) {
            if (!StringUtils.equals(string, (CharSequence)pair.getKey())) continue;
            arrayList.add(pair.getValue());
        }
        return arrayList;
    }

    @Override
    public Object getFirstContextValue(String string) {
        for (Pair pair : this.contextValues) {
            if (!StringUtils.equals(string, (CharSequence)pair.getKey())) continue;
            return pair.getValue();
        }
        return null;
    }

    @Override
    public Set getContextLabels() {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Pair pair : this.contextValues) {
            hashSet.add(pair.getKey());
        }
        return hashSet;
    }

    @Override
    public List getContextEntries() {
        return this.contextValues;
    }

    @Override
    public String getFormattedExceptionMessage(String string) {
        StringBuilder stringBuilder = new StringBuilder(256);
        if (string != null) {
            stringBuilder.append(string);
        }
        if (this.contextValues.size() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("Exception Context:\n");
            int n2 = 0;
            for (Object object : this.contextValues) {
                stringBuilder.append("\t[");
                stringBuilder.append(++n2);
                stringBuilder.append(':');
                stringBuilder.append((String)((Pair)object).getKey());
                stringBuilder.append("=");
                object = ((Pair)object).getValue();
                if (object == null) {
                    stringBuilder.append("null");
                } else {
                    try {
                        object = object.toString();
                    }
                    catch (Exception exception) {
                        object = "Exception thrown on toString(): " + ExceptionUtils.getStackTrace(exception);
                    }
                    stringBuilder.append((String)object);
                }
                stringBuilder.append("]\n");
            }
            stringBuilder.append("---------------------------------");
        }
        return stringBuilder.toString();
    }
}

