/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.event;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.event.EventListenerSupport$ProxyInvocationHandler;

public class EventListenerSupport
implements Serializable {
    private static final long serialVersionUID = 3593265990380473632L;
    private List listeners = new CopyOnWriteArrayList();
    private transient Object proxy;
    private transient Object[] prototypeArray;

    public static EventListenerSupport create(Class clazz) {
        return new EventListenerSupport(clazz);
    }

    public EventListenerSupport(Class clazz) {
        this(clazz, Thread.currentThread().getContextClassLoader());
    }

    public EventListenerSupport(Class clazz, ClassLoader classLoader) {
        this();
        Validate.notNull(clazz, "Listener interface cannot be null.", new Object[0]);
        Validate.notNull(classLoader, "ClassLoader cannot be null.", new Object[0]);
        Validate.isTrue(clazz.isInterface(), "Class {0} is not an interface", clazz.getName());
        this.initializeTransientFields(clazz, classLoader);
    }

    private EventListenerSupport() {
    }

    public Object fire() {
        return this.proxy;
    }

    public void addListener(Object object) {
        Validate.notNull(object, "Listener object cannot be null.", new Object[0]);
        this.listeners.add(object);
    }

    public void removeListener(Object object) {
        Validate.notNull(object, "Listener object cannot be null.", new Object[0]);
        this.listeners.remove(object);
    }

    public Object[] getListeners() {
        return this.listeners.toArray(this.prototypeArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        ArrayList arrayList = new ArrayList();
        ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(new ByteArrayOutputStream());
        for (Object e2 : this.listeners) {
            try {
                objectOutputStream2.writeObject(e2);
                arrayList.add(e2);
            }
            catch (IOException iOException) {
                objectOutputStream2 = new ObjectOutputStream(new ByteArrayOutputStream());
            }
        }
        objectOutputStream.writeObject(arrayList.toArray(this.prototypeArray));
    }

    private void readObject(ObjectInputStream object) {
        object = (Object[])object.readObject();
        this.listeners = new CopyOnWriteArrayList<Object>((E[])object);
        object = object.getClass().getComponentType();
        this.initializeTransientFields((Class)object, Thread.currentThread().getContextClassLoader());
    }

    private void initializeTransientFields(Class clazz, ClassLoader classLoader) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, 0);
        this.prototypeArray = objectArray;
        this.createProxy(clazz, classLoader);
    }

    private void createProxy(Class clazz, ClassLoader classLoader) {
        this.proxy = clazz.cast(Proxy.newProxyInstance(classLoader, new Class[]{clazz}, this.createInvocationHandler()));
    }

    protected InvocationHandler createInvocationHandler() {
        return new EventListenerSupport$ProxyInvocationHandler(this);
    }

    static /* synthetic */ List a(EventListenerSupport eventListenerSupport) {
        return eventListenerSupport.listeners;
    }
}

