/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.concurrent.BackgroundInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.MultiBackgroundInitializer$MultiBackgroundInitializerResults;

public class MultiBackgroundInitializer
extends BackgroundInitializer {
    private final Map childInitializers = new HashMap();

    public MultiBackgroundInitializer() {
    }

    public MultiBackgroundInitializer(ExecutorService executorService) {
        super(executorService);
    }

    public void addInitializer(String string, BackgroundInitializer backgroundInitializer) {
        if (string == null) {
            throw new IllegalArgumentException("Name of child initializer must not be null!");
        }
        if (backgroundInitializer == null) {
            throw new IllegalArgumentException("Child initializer must not be null!");
        }
        MultiBackgroundInitializer multiBackgroundInitializer = this;
        synchronized (multiBackgroundInitializer) {
            if (this.isStarted()) {
                throw new IllegalStateException("addInitializer() must not be called after start()!");
            }
            this.childInitializers.put(string, backgroundInitializer);
            return;
        }
    }

    @Override
    protected int getTaskCount() {
        int n2 = 1;
        for (BackgroundInitializer backgroundInitializer : this.childInitializers.values()) {
            n2 += backgroundInitializer.getTaskCount();
        }
        return n2;
    }

    @Override
    protected MultiBackgroundInitializer$MultiBackgroundInitializerResults initialize() {
        Object object2;
        HashMap hashMap;
        Iterator iterator = this;
        synchronized (iterator) {
            hashMap = new HashMap(this.childInitializers);
        }
        iterator = this.getActiveExecutor();
        for (Object object2 : hashMap.values()) {
            if (((BackgroundInitializer)object2).getExternalExecutor() == null) {
                ((BackgroundInitializer)object2).setExternalExecutor((ExecutorService)((Object)iterator));
            }
            ((BackgroundInitializer)object2).start();
        }
        HashMap hashMap2 = new HashMap();
        object2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            try {
                hashMap2.put(entry.getKey(), ((BackgroundInitializer)entry.getValue()).get());
            }
            catch (ConcurrentException concurrentException) {
                object2.put(entry.getKey(), concurrentException);
            }
        }
        return new MultiBackgroundInitializer$MultiBackgroundInitializerResults(hashMap, hashMap2, (Map)object2);
    }
}

