/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentRuntimeException;
import org.apache.commons.lang3.concurrent.ConcurrentUtils$ConstantFuture;

public class ConcurrentUtils {
    private ConcurrentUtils() {
    }

    public static ConcurrentException extractCause(ExecutionException executionException) {
        if (executionException == null || executionException.getCause() == null) {
            return null;
        }
        ConcurrentUtils.throwCause(executionException);
        return new ConcurrentException(executionException.getMessage(), executionException.getCause());
    }

    public static ConcurrentRuntimeException extractCauseUnchecked(ExecutionException executionException) {
        if (executionException == null || executionException.getCause() == null) {
            return null;
        }
        ConcurrentUtils.throwCause(executionException);
        return new ConcurrentRuntimeException(executionException.getMessage(), executionException.getCause());
    }

    public static void handleCause(ExecutionException exception) {
        if ((exception = ConcurrentUtils.extractCause(exception)) != null) {
            throw exception;
        }
    }

    public static void handleCauseUnchecked(ExecutionException exception) {
        if ((exception = ConcurrentUtils.extractCauseUnchecked(exception)) != null) {
            throw exception;
        }
    }

    static Throwable a(Throwable throwable) {
        if (throwable != null && !(throwable instanceof RuntimeException) && !(throwable instanceof Error)) {
            return throwable;
        }
        throw new IllegalArgumentException("Not a checked exception: " + throwable);
    }

    private static void throwCause(ExecutionException executionException) {
        if (executionException.getCause() instanceof RuntimeException) {
            throw (RuntimeException)executionException.getCause();
        }
        if (executionException.getCause() instanceof Error) {
            throw (Error)executionException.getCause();
        }
    }

    public static Object initialize(ConcurrentInitializer concurrentInitializer) {
        if (concurrentInitializer != null) {
            return concurrentInitializer.get();
        }
        return null;
    }

    public static Object initializeUnchecked(ConcurrentInitializer concurrentInitializer) {
        try {
            return ConcurrentUtils.initialize(concurrentInitializer);
        }
        catch (ConcurrentException concurrentException) {
            throw new ConcurrentRuntimeException(concurrentException.getCause());
        }
    }

    public static Object putIfAbsent(ConcurrentMap object, Object object2, Object object3) {
        if (object == null) {
            return null;
        }
        if ((object = object.putIfAbsent(object2, object3)) != null) {
            return object;
        }
        return object3;
    }

    public static Object createIfAbsent(ConcurrentMap concurrentMap, Object object, ConcurrentInitializer concurrentInitializer) {
        if (concurrentMap == null || concurrentInitializer == null) {
            return null;
        }
        Object v = concurrentMap.get(object);
        if (v == null) {
            return ConcurrentUtils.putIfAbsent(concurrentMap, object, concurrentInitializer.get());
        }
        return v;
    }

    public static Object createIfAbsentUnchecked(ConcurrentMap concurrentMap, Object object, ConcurrentInitializer concurrentInitializer) {
        try {
            return ConcurrentUtils.createIfAbsent(concurrentMap, object, concurrentInitializer);
        }
        catch (ConcurrentException concurrentException) {
            throw new ConcurrentRuntimeException(concurrentException.getCause());
        }
    }

    public static Future constantFuture(Object object) {
        return new ConcurrentUtils$ConstantFuture(object);
    }
}

