/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Validate {
    private static final String DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE = "The value %s is not in the specified exclusive range of %s to %s";
    private static final String DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE = "The value %s is not in the specified inclusive range of %s to %s";
    private static final String DEFAULT_MATCHES_PATTERN_EX = "The string %s does not match the pattern %s";
    private static final String DEFAULT_IS_NULL_EX_MESSAGE = "The validated object is null";
    private static final String DEFAULT_IS_TRUE_EX_MESSAGE = "The validated expression is false";
    private static final String DEFAULT_NO_NULL_ELEMENTS_ARRAY_EX_MESSAGE = "The validated array contains null element at index: %d";
    private static final String DEFAULT_NO_NULL_ELEMENTS_COLLECTION_EX_MESSAGE = "The validated collection contains null element at index: %d";
    private static final String DEFAULT_NOT_BLANK_EX_MESSAGE = "The validated character sequence is blank";
    private static final String DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE = "The validated array is empty";
    private static final String DEFAULT_NOT_EMPTY_CHAR_SEQUENCE_EX_MESSAGE = "The validated character sequence is empty";
    private static final String DEFAULT_NOT_EMPTY_COLLECTION_EX_MESSAGE = "The validated collection is empty";
    private static final String DEFAULT_NOT_EMPTY_MAP_EX_MESSAGE = "The validated map is empty";
    private static final String DEFAULT_VALID_INDEX_ARRAY_EX_MESSAGE = "The validated array index is invalid: %d";
    private static final String DEFAULT_VALID_INDEX_CHAR_SEQUENCE_EX_MESSAGE = "The validated character sequence index is invalid: %d";
    private static final String DEFAULT_VALID_INDEX_COLLECTION_EX_MESSAGE = "The validated collection index is invalid: %d";
    private static final String DEFAULT_VALID_STATE_EX_MESSAGE = "The validated state is false";
    private static final String DEFAULT_IS_ASSIGNABLE_EX_MESSAGE = "Cannot assign a %s to a %s";
    private static final String DEFAULT_IS_INSTANCE_OF_EX_MESSAGE = "Expected type: %s, actual: %s";

    public static void isTrue(boolean bl, String string, long l2) {
        if (!bl) {
            throw new IllegalArgumentException(String.format(string, l2));
        }
    }

    public static void isTrue(boolean bl, String string, double d2) {
        if (!bl) {
            throw new IllegalArgumentException(String.format(string, d2));
        }
    }

    public static void isTrue(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    public static void isTrue(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException(DEFAULT_IS_TRUE_EX_MESSAGE);
        }
    }

    public static Object notNull(Object object) {
        return Validate.notNull(object, DEFAULT_IS_NULL_EX_MESSAGE, new Object[0]);
    }

    public static Object notNull(Object object, String string, Object ... objectArray) {
        if (object == null) {
            throw new NullPointerException(String.format(string, objectArray));
        }
        return object;
    }

    public static Object[] notEmpty(Object[] objectArray, String string, Object ... objectArray2) {
        if (objectArray == null) {
            throw new NullPointerException(String.format(string, objectArray2));
        }
        if (objectArray.length == 0) {
            throw new IllegalArgumentException(String.format(string, objectArray2));
        }
        return objectArray;
    }

    public static Object[] notEmpty(Object[] objectArray) {
        return Validate.notEmpty(objectArray, DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE, new Object[0]);
    }

    public static Collection notEmpty(Collection collection, String string, Object ... objectArray) {
        if (collection == null) {
            throw new NullPointerException(String.format(string, objectArray));
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
        return collection;
    }

    public static Collection notEmpty(Collection collection) {
        return Validate.notEmpty(collection, DEFAULT_NOT_EMPTY_COLLECTION_EX_MESSAGE, new Object[0]);
    }

    public static Map notEmpty(Map map, String string, Object ... objectArray) {
        if (map == null) {
            throw new NullPointerException(String.format(string, objectArray));
        }
        if (map.isEmpty()) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
        return map;
    }

    public static Map notEmpty(Map map) {
        return Validate.notEmpty(map, DEFAULT_NOT_EMPTY_MAP_EX_MESSAGE, new Object[0]);
    }

    public static CharSequence notEmpty(CharSequence charSequence, String string, Object ... objectArray) {
        if (charSequence == null) {
            throw new NullPointerException(String.format(string, objectArray));
        }
        if (charSequence.length() == 0) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
        return charSequence;
    }

    public static CharSequence notEmpty(CharSequence charSequence) {
        return Validate.notEmpty(charSequence, DEFAULT_NOT_EMPTY_CHAR_SEQUENCE_EX_MESSAGE, new Object[0]);
    }

    public static CharSequence notBlank(CharSequence charSequence, String string, Object ... objectArray) {
        if (charSequence == null) {
            throw new NullPointerException(String.format(string, objectArray));
        }
        if (StringUtils.isBlank(charSequence)) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
        return charSequence;
    }

    public static CharSequence notBlank(CharSequence charSequence) {
        return Validate.notBlank(charSequence, DEFAULT_NOT_BLANK_EX_MESSAGE, new Object[0]);
    }

    public static Object[] noNullElements(Object[] objectArray, String string, Object ... objectArray2) {
        Validate.notNull(objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] != null) continue;
            objectArray = ArrayUtils.add(objectArray2, (Object)i2);
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
        return objectArray;
    }

    public static Object[] noNullElements(Object[] objectArray) {
        return Validate.noNullElements(objectArray, DEFAULT_NO_NULL_ELEMENTS_ARRAY_EX_MESSAGE, new Object[0]);
    }

    public static Iterable noNullElements(Iterable objectArray, String string, Object ... objectArray2) {
        Validate.notNull(objectArray);
        int n2 = 0;
        Iterator iterator = objectArray.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() == null) {
                objectArray = ArrayUtils.addAll(objectArray2, n2);
                throw new IllegalArgumentException(String.format(string, objectArray));
            }
            ++n2;
        }
        return objectArray;
    }

    public static Iterable noNullElements(Iterable iterable) {
        return Validate.noNullElements(iterable, DEFAULT_NO_NULL_ELEMENTS_COLLECTION_EX_MESSAGE, new Object[0]);
    }

    public static Object[] validIndex(Object[] objectArray, int n2, String string, Object ... objectArray2) {
        Validate.notNull(objectArray);
        if (n2 < 0 || n2 >= objectArray.length) {
            throw new IndexOutOfBoundsException(String.format(string, objectArray2));
        }
        return objectArray;
    }

    public static Object[] validIndex(Object[] objectArray, int n2) {
        return Validate.validIndex(objectArray, n2, DEFAULT_VALID_INDEX_ARRAY_EX_MESSAGE, n2);
    }

    public static Collection validIndex(Collection collection, int n2, String string, Object ... objectArray) {
        Validate.notNull(collection);
        if (n2 < 0 || n2 >= collection.size()) {
            throw new IndexOutOfBoundsException(String.format(string, objectArray));
        }
        return collection;
    }

    public static Collection validIndex(Collection collection, int n2) {
        return Validate.validIndex(collection, n2, DEFAULT_VALID_INDEX_COLLECTION_EX_MESSAGE, n2);
    }

    public static CharSequence validIndex(CharSequence charSequence, int n2, String string, Object ... objectArray) {
        Validate.notNull(charSequence);
        if (n2 < 0 || n2 >= charSequence.length()) {
            throw new IndexOutOfBoundsException(String.format(string, objectArray));
        }
        return charSequence;
    }

    public static CharSequence validIndex(CharSequence charSequence, int n2) {
        return Validate.validIndex(charSequence, n2, DEFAULT_VALID_INDEX_CHAR_SEQUENCE_EX_MESSAGE, n2);
    }

    public static void validState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException(DEFAULT_VALID_STATE_EX_MESSAGE);
        }
    }

    public static void validState(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new IllegalStateException(String.format(string, objectArray));
        }
    }

    public static void matchesPattern(CharSequence charSequence, String string) {
        if (!Pattern.matches(string, charSequence)) {
            throw new IllegalArgumentException(String.format(DEFAULT_MATCHES_PATTERN_EX, charSequence, string));
        }
    }

    public static void matchesPattern(CharSequence charSequence, String string, String string2, Object ... objectArray) {
        if (!Pattern.matches(string, charSequence)) {
            throw new IllegalArgumentException(String.format(string2, objectArray));
        }
    }

    public static void inclusiveBetween(Object object, Object object2, Comparable comparable) {
        if (comparable.compareTo(object) < 0 || comparable.compareTo(object2) > 0) {
            throw new IllegalArgumentException(String.format(DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE, comparable, object, object2));
        }
    }

    public static void inclusiveBetween(Object object, Object object2, Comparable comparable, String string, Object ... objectArray) {
        if (comparable.compareTo(object) < 0 || comparable.compareTo(object2) > 0) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    public static void exclusiveBetween(Object object, Object object2, Comparable comparable) {
        if (comparable.compareTo(object) <= 0 || comparable.compareTo(object2) >= 0) {
            throw new IllegalArgumentException(String.format(DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE, comparable, object, object2));
        }
    }

    public static void exclusiveBetween(Object object, Object object2, Comparable comparable, String string, Object ... objectArray) {
        if (comparable.compareTo(object) <= 0 || comparable.compareTo(object2) >= 0) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    public static void isInstanceOf(Class clazz, Object object) {
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException(String.format(DEFAULT_IS_INSTANCE_OF_EX_MESSAGE, clazz.getName(), object == null ? "null" : object.getClass().getName()));
        }
    }

    public static void isInstanceOf(Class clazz, Object object, String string, Object ... objectArray) {
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    public static void isAssignableFrom(Class clazz, Class clazz2) {
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException(String.format(DEFAULT_IS_ASSIGNABLE_EX_MESSAGE, clazz2 == null ? "null" : clazz2.getName(), clazz.getName()));
        }
    }

    public static void isAssignableFrom(Class clazz, Class clazz2, String string, Object ... objectArray) {
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }
}

