/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils$ClassLoaderAwareObjectInputStream;

public class SerializationUtils {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Serializable clone(Serializable serializable) {
        if (serializable == null) {
            return null;
        }
        Object object = SerializationUtils.serialize(serializable);
        object = new ByteArrayInputStream((byte[])object);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new SerializationUtils$ClassLoaderAwareObjectInputStream((InputStream)object, serializable.getClass().getClassLoader());
            serializable = (Serializable)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                throw new SerializationException("ClassNotFoundException while reading cloned object data", classNotFoundException);
                catch (IOException iOException) {
                    throw new SerializationException("IOException while reading cloned object data", iOException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (objectInputStream == null) throw throwable;
                    objectInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new SerializationException("IOException on closing cloned object data InputStream.", iOException);
                }
            }
        }
        try {
            objectInputStream.close();
            return serializable;
        }
        catch (IOException iOException) {
            throw new SerializationException("IOException on closing cloned object data InputStream.", iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void serialize(Serializable serializable, OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("The OutputStream must not be null");
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
        }
        catch (IOException iOException) {
            try {
                throw new SerializationException(iOException);
            }
            catch (Throwable throwable) {
                try {
                    if (objectOutputStream == null) throw throwable;
                    objectOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
        }
        try {
            objectOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static byte[] serialize(Serializable serializable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        SerializationUtils.serialize(serializable, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(InputStream object) {
        if (object == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream((InputStream)object);
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                throw new SerializationException(classNotFoundException);
                catch (IOException iOException) {
                    throw new SerializationException(iOException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (objectInputStream == null) throw throwable;
                    objectInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            objectInputStream.close();
            return object;
        }
        catch (IOException iOException) {}
        return object;
    }

    public static Object deserialize(byte[] object) {
        if (object == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        object = byteArrayInputStream;
        return SerializationUtils.deserialize(byteArrayInputStream);
    }
}

