/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang3.Range$ComparableComparator;

public final class Range
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Comparator comparator;
    private final Object minimum;
    private final Object maximum;
    private transient int hashCode;
    private transient String toString;

    public static Range is(Comparable comparable) {
        return Range.between(comparable, comparable, null);
    }

    public static Range is(Object object, Comparator comparator) {
        return Range.between(object, object, comparator);
    }

    public static Range between(Comparable comparable, Comparable comparable2) {
        return Range.between(comparable, comparable2, null);
    }

    public static Range between(Object object, Object object2, Comparator comparator) {
        return new Range(object, object2, comparator);
    }

    private Range(Object object, Object object2, Comparator comparator) {
        if (object == null || object2 == null) {
            throw new IllegalArgumentException("Elements in a range must not be null: element1=" + object + ", element2=" + object2);
        }
        if (comparator == null) {
            comparator = Range$ComparableComparator.INSTANCE;
        }
        if (comparator.compare(object, object2) <= 0) {
            this.minimum = object;
            this.maximum = object2;
        } else {
            this.minimum = object2;
            this.maximum = object;
        }
        this.comparator = comparator;
    }

    public final Object getMinimum() {
        return this.minimum;
    }

    public final Object getMaximum() {
        return this.maximum;
    }

    public final Comparator getComparator() {
        return this.comparator;
    }

    public final boolean isNaturalOrdering() {
        return this.comparator == Range$ComparableComparator.INSTANCE;
    }

    public final boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        return this.comparator.compare(object, this.minimum) >= 0 && this.comparator.compare(object, this.maximum) <= 0;
    }

    public final boolean isAfter(Object object) {
        if (object == null) {
            return false;
        }
        return this.comparator.compare(object, this.minimum) < 0;
    }

    public final boolean isStartedBy(Object object) {
        if (object == null) {
            return false;
        }
        return this.comparator.compare(object, this.minimum) == 0;
    }

    public final boolean isEndedBy(Object object) {
        if (object == null) {
            return false;
        }
        return this.comparator.compare(object, this.maximum) == 0;
    }

    public final boolean isBefore(Object object) {
        if (object == null) {
            return false;
        }
        return this.comparator.compare(object, this.maximum) > 0;
    }

    public final int elementCompareTo(Object object) {
        if (object == null) {
            throw new NullPointerException("Element is null");
        }
        if (this.isAfter(object)) {
            return -1;
        }
        if (this.isBefore(object)) {
            return 1;
        }
        return 0;
    }

    public final boolean containsRange(Range range) {
        if (range == null) {
            return false;
        }
        return this.contains(range.minimum) && this.contains(range.maximum);
    }

    public final boolean isAfterRange(Range range) {
        if (range == null) {
            return false;
        }
        return this.isAfter(range.maximum);
    }

    public final boolean isOverlappedBy(Range range) {
        if (range == null) {
            return false;
        }
        return range.contains(this.minimum) || range.contains(this.maximum) || this.contains(range.minimum);
    }

    public final boolean isBeforeRange(Range range) {
        if (range == null) {
            return false;
        }
        return this.isBefore(range.minimum);
    }

    public final Range intersectionWith(Range object) {
        if (!this.isOverlappedBy((Range)object)) {
            throw new IllegalArgumentException(String.format("Cannot calculate intersection with non-overlapping range %s", object));
        }
        if (this.equals(object)) {
            return this;
        }
        Object object2 = this.getComparator().compare(this.minimum, ((Range)object).minimum) < 0 ? ((Range)object).minimum : this.minimum;
        object = this.getComparator().compare(this.maximum, ((Range)object).maximum) < 0 ? this.maximum : ((Range)object).maximum;
        return Range.between(object2, object, this.getComparator());
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        object = (Range)object;
        return this.minimum.equals(((Range)object).minimum) && this.maximum.equals(((Range)object).maximum);
    }

    public final int hashCode() {
        int n2 = this.hashCode;
        if (this.hashCode == 0) {
            n2 = 629 + this.getClass().hashCode();
            n2 = n2 * 37 + this.minimum.hashCode();
            this.hashCode = n2 = n2 * 37 + this.maximum.hashCode();
        }
        return n2;
    }

    public final String toString() {
        CharSequence charSequence = this.toString;
        if (charSequence == null) {
            charSequence = new StringBuilder(32);
            ((StringBuilder)charSequence).append('[');
            ((StringBuilder)charSequence).append(this.minimum);
            ((StringBuilder)charSequence).append("..");
            ((StringBuilder)charSequence).append(this.maximum);
            ((StringBuilder)charSequence).append(']');
            charSequence = ((StringBuilder)charSequence).toString();
            this.toString = charSequence;
        }
        return charSequence;
    }

    public final String toString(String string) {
        return String.format(string, this.minimum, this.maximum, this.comparator);
    }
}

