/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils$Null;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.CloneFailedException;
import org.apache.commons.lang3.mutable.MutableInt;

public class ObjectUtils {
    public static final ObjectUtils$Null NULL = new ObjectUtils$Null();

    public static Object defaultIfNull(Object object, Object object2) {
        if (object != null) {
            return object;
        }
        return object2;
    }

    public static Object firstNonNull(Object ... objectArray) {
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (object == null) continue;
                return object;
            }
        }
        return null;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static boolean notEqual(Object object, Object object2) {
        return !ObjectUtils.equals(object, object2);
    }

    public static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }

    public static int hashCodeMulti(Object ... objectArray) {
        int n2 = 1;
        if (objectArray != null) {
            for (Object object : objectArray) {
                n2 = n2 * 31 + ObjectUtils.hashCode(object);
            }
        }
        return n2;
    }

    public static String identityToString(Object object) {
        if (object == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        ObjectUtils.identityToString(stringBuffer, object);
        return stringBuffer.toString();
    }

    public static void identityToString(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            throw new NullPointerException("Cannot get the toString of a null identity");
        }
        stringBuffer.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
    }

    public static String toString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String toString(Object object, String string) {
        if (object == null) {
            return string;
        }
        return object.toString();
    }

    public static Comparable min(Comparable ... comparableArray) {
        Comparable comparable = null;
        if (comparableArray != null) {
            for (Comparable comparable2 : comparableArray) {
                if (ObjectUtils.compare(comparable2, comparable, true) >= 0) continue;
                comparable = comparable2;
            }
        }
        return comparable;
    }

    public static Comparable max(Comparable ... comparableArray) {
        Comparable comparable = null;
        if (comparableArray != null) {
            for (Comparable comparable2 : comparableArray) {
                if (ObjectUtils.compare(comparable2, comparable, false) <= 0) continue;
                comparable = comparable2;
            }
        }
        return comparable;
    }

    public static int compare(Comparable comparable, Comparable comparable2) {
        return ObjectUtils.compare(comparable, comparable2, false);
    }

    public static int compare(Comparable comparable, Comparable comparable2, boolean bl) {
        if (comparable == comparable2) {
            return 0;
        }
        if (comparable == null) {
            if (bl) {
                return 1;
            }
            return -1;
        }
        if (comparable2 == null) {
            if (bl) {
                return -1;
            }
            return 1;
        }
        return comparable.compareTo(comparable2);
    }

    public static Comparable median(Comparable ... object) {
        Validate.notEmpty(object);
        Validate.noNullElements(object);
        TreeSet treeSet = new TreeSet();
        Collections.addAll(treeSet, object);
        object = (Comparable)treeSet.toArray()[(treeSet.size() - 1) / 2];
        return object;
    }

    public static Object median(Comparator object, Object ... objectArray) {
        Validate.notEmpty(objectArray, "null/empty items", new Object[0]);
        Validate.noNullElements(objectArray);
        Validate.notNull(object, "null comparator", new Object[0]);
        object = new TreeSet(object);
        Collections.addAll(object, objectArray);
        object = ((AbstractCollection)object).toArray()[(((TreeSet)object).size() - 1) / 2];
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static Object mode(Object ... object) {
        if (ArrayUtils.isNotEmpty((Object[])object)) {
            void var0_3;
            HashMap<Object, MutableInt> hashMap = new HashMap<Object, MutableInt>(((Object)object).length);
            for (Object object2 : object) {
                MutableInt mutableInt = (MutableInt)hashMap.get(object2);
                if (mutableInt == null) {
                    hashMap.put(object2, new MutableInt(1));
                    continue;
                }
                mutableInt.increment();
            }
            Object var0_2 = null;
            int n2 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                int n3 = ((MutableInt)entry.getValue()).intValue();
                if (n3 == n2) {
                    Object var0_4 = null;
                    continue;
                }
                if (n3 <= n2) continue;
                n2 = n3;
                Object k2 = entry.getKey();
            }
            return var0_3;
        }
        return null;
    }

    public static Object clone(Object object) {
        if (object instanceof Cloneable) {
            Class<?> clazz;
            if (object.getClass().isArray()) {
                clazz = object.getClass().getComponentType();
                if (!clazz.isPrimitive()) {
                    clazz = ((Object[])object).clone();
                } else {
                    int n2 = Array.getLength(object);
                    clazz = Array.newInstance(clazz, n2);
                    while (n2-- > 0) {
                        Array.set(clazz, n2, Array.get(object, n2));
                    }
                }
            } else {
                try {
                    clazz = object.getClass().getMethod("clone", new Class[0]);
                    clazz = ((Method)((Object)clazz)).invoke(object, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new CloneFailedException("Cloneable type " + object.getClass().getName() + " has no clone method", noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new CloneFailedException("Cannot clone Cloneable type " + object.getClass().getName(), illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new CloneFailedException("Exception cloning Cloneable type " + object.getClass().getName(), invocationTargetException.getCause());
                }
            }
            return clazz;
        }
        return null;
    }

    public static Object cloneIfPossible(Object object) {
        Object object2 = ObjectUtils.clone(object);
        if (object2 == null) {
            return object;
        }
        return object2;
    }
}

