/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.LocaleUtils$SyncAvoid;

public class LocaleUtils {
    private static final ConcurrentMap cLanguagesByCountry = new ConcurrentHashMap();
    private static final ConcurrentMap cCountriesByLanguage = new ConcurrentHashMap();

    public static Locale toLocale(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 != 2 && n2 != 5 && n2 < 7) {
            throw new IllegalArgumentException("Invalid locale format: " + string);
        }
        char c2 = string.charAt(0);
        char c3 = string.charAt(1);
        if (c2 < 'a' || c2 > 'z' || c3 < 'a' || c3 > 'z') {
            throw new IllegalArgumentException("Invalid locale format: " + string);
        }
        if (n2 == 2) {
            return new Locale(string, "");
        }
        if (string.charAt(2) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + string);
        }
        c2 = string.charAt(3);
        if (c2 == '_') {
            return new Locale(string.substring(0, 2), "", string.substring(4));
        }
        c3 = string.charAt(4);
        if (c2 < 'A' || c2 > 'Z' || c3 < 'A' || c3 > 'Z') {
            throw new IllegalArgumentException("Invalid locale format: " + string);
        }
        if (n2 == 5) {
            return new Locale(string.substring(0, 2), string.substring(3, 5));
        }
        if (string.charAt(5) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + string);
        }
        return new Locale(string.substring(0, 2), string.substring(3, 5), string.substring(6));
    }

    public static List localeLookupList(Locale locale) {
        return LocaleUtils.localeLookupList(locale, locale);
    }

    public static List localeLookupList(Locale locale, Locale locale2) {
        ArrayList<Locale> arrayList = new ArrayList<Locale>(4);
        if (locale != null) {
            arrayList.add(locale);
            if (locale.getVariant().length() > 0) {
                arrayList.add(new Locale(locale.getLanguage(), locale.getCountry()));
            }
            if (locale.getCountry().length() > 0) {
                arrayList.add(new Locale(locale.getLanguage(), ""));
            }
            if (!arrayList.contains(locale2)) {
                arrayList.add(locale2);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static List availableLocaleList() {
        return LocaleUtils$SyncAvoid.a();
    }

    public static Set availableLocaleSet() {
        return LocaleUtils$SyncAvoid.b();
    }

    public static boolean isAvailableLocale(Locale locale) {
        return LocaleUtils.availableLocaleList().contains(locale);
    }

    public static List languagesByCountry(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        List<Locale> list = (ArrayList)cLanguagesByCountry.get(string);
        if (list == null) {
            list = new ArrayList();
            List list2 = LocaleUtils.availableLocaleList();
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                Locale locale = (Locale)list2.get(i2);
                if (!string.equals(locale.getCountry()) || locale.getVariant().length() != 0) continue;
                list.add(locale);
            }
            list = Collections.unmodifiableList(list);
            cLanguagesByCountry.putIfAbsent(string, list);
            list = (List)cLanguagesByCountry.get(string);
        }
        return list;
    }

    public static List countriesByLanguage(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        List<Locale> list = (ArrayList)cCountriesByLanguage.get(string);
        if (list == null) {
            list = new ArrayList();
            List list2 = LocaleUtils.availableLocaleList();
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                Locale locale = (Locale)list2.get(i2);
                if (!string.equals(locale.getLanguage()) || locale.getCountry().length() == 0 || locale.getVariant().length() != 0) continue;
                list.add(locale);
            }
            list = Collections.unmodifiableList(list);
            cCountriesByLanguage.putIfAbsent(string, list);
            list = (List)cCountriesByLanguage.get(string);
        }
        return list;
    }
}

