/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class EnumUtils {
    public static Map getEnumMap(Class enumArray) {
        LinkedHashMap<String, Enum> linkedHashMap = new LinkedHashMap<String, Enum>();
        for (Enum enum_ : (Enum[])enumArray.getEnumConstants()) {
            linkedHashMap.put(enum_.name(), enum_);
        }
        return linkedHashMap;
    }

    public static List getEnumList(Class clazz) {
        return new ArrayList(Arrays.asList(clazz.getEnumConstants()));
    }

    public static boolean isValidEnum(Class clazz, String string) {
        if (string == null) {
            return false;
        }
        try {
            Enum.valueOf(clazz, string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static Enum getEnum(Class clazz, String string) {
        if (string == null) {
            return null;
        }
        try {
            return Enum.valueOf(clazz, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static long generateBitVector(Class object, Iterable object2) {
        EnumUtils.checkBitVectorable((Class)object);
        Validate.notNull(object2);
        long l2 = 0L;
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (Enum)object.next();
            l2 |= (long)(1 << ((Enum)object2).ordinal());
        }
        return l2;
    }

    public static long generateBitVector(Class clazz, Enum ... enumArray) {
        Validate.noNullElements(enumArray);
        return EnumUtils.generateBitVector(clazz, Arrays.asList(enumArray));
    }

    public static EnumSet processBitVector(Class serializable, long l2) {
        Enum[] enumArray = (Enum[])EnumUtils.checkBitVectorable((Class)serializable).getEnumConstants();
        serializable = EnumSet.noneOf(serializable);
        for (Enum enum_ : enumArray) {
            if ((l2 & (long)(1 << enum_.ordinal())) == 0L) continue;
            ((AbstractCollection)((Object)serializable)).add(enum_);
        }
        return serializable;
    }

    private static Class checkBitVectorable(Class clazz) {
        Validate.notNull(clazz, "EnumClass must be defined.", new Object[0]);
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        Validate.isTrue(enumArray != null, "%s does not seem to be an Enum type", clazz);
        Validate.isTrue(enumArray.length <= 64, "Cannot store %s %s values in %s bits", enumArray.length, clazz.getSimpleName(), 64);
        return clazz;
    }
}

