/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class LockableFileWriter
extends Writer {
    private static final String LCK = ".lck";
    private final Writer out;
    private final File lockFile;

    public LockableFileWriter(String string) {
        this(string, false, null);
    }

    public LockableFileWriter(String string, boolean bl) {
        this(string, bl, null);
    }

    public LockableFileWriter(String string, boolean bl, String string2) {
        this(new File(string), bl, string2);
    }

    public LockableFileWriter(File file) {
        this(file, false, null);
    }

    public LockableFileWriter(File file, boolean bl) {
        this(file, bl, null);
    }

    public LockableFileWriter(File file, boolean bl, String string) {
        this(file, Charset.defaultCharset(), bl, string);
    }

    public LockableFileWriter(File file, Charset charset) {
        this(file, charset, false, null);
    }

    public LockableFileWriter(File file, String string) {
        this(file, string, false, null);
    }

    public LockableFileWriter(File file, Charset charset, boolean bl, String object) {
        file = file.getAbsoluteFile();
        if (file.getParentFile() != null) {
            FileUtils.forceMkdir(file.getParentFile());
        }
        if (file.isDirectory()) {
            throw new IOException("File specified is a directory");
        }
        if (object == null) {
            object = System.getProperty("java.io.tmpdir");
        }
        object = new File((String)object);
        FileUtils.forceMkdir((File)object);
        this.testLockDir((File)object);
        this.lockFile = new File((File)object, file.getName() + LCK);
        this.createLock();
        this.out = this.initWriter(file, charset, bl);
    }

    public LockableFileWriter(File file, String string, boolean bl, String string2) {
        this(file, Charsets.toCharset(string), bl, string2);
    }

    private void testLockDir(File file) {
        if (!file.exists()) {
            throw new IOException("Could not find lockDir: " + file.getAbsolutePath());
        }
        if (!file.canWrite()) {
            throw new IOException("Could not write to lockDir: " + file.getAbsolutePath());
        }
    }

    private void createLock() {
        Class<LockableFileWriter> clazz = LockableFileWriter.class;
        synchronized (LockableFileWriter.class) {
            if (!this.lockFile.createNewFile()) {
                throw new IOException("Can't write file, lock " + this.lockFile.getAbsolutePath() + " exists");
            }
            this.lockFile.deleteOnExit();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private Writer initWriter(File file, Charset object, boolean bl) {
        boolean bl2 = file.exists();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file.getAbsolutePath(), bl);
            object = new OutputStreamWriter((OutputStream)fileOutputStream, Charsets.toCharset((Charset)object));
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(null);
            IOUtils.closeQuietly(fileOutputStream);
            FileUtils.deleteQuietly(this.lockFile);
            if (!bl2) {
                FileUtils.deleteQuietly(file);
            }
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            IOUtils.closeQuietly(null);
            IOUtils.closeQuietly(fileOutputStream);
            FileUtils.deleteQuietly(this.lockFile);
            if (!bl2) {
                FileUtils.deleteQuietly(file);
            }
            throw runtimeException;
        }
        return object;
    }

    @Override
    public void close() {
        try {
            this.out.close();
            return;
        }
        finally {
            this.lockFile.delete();
        }
    }

    @Override
    public void write(int n2) {
        this.out.write(n2);
    }

    @Override
    public void write(char[] cArray) {
        this.out.write(cArray);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) {
        this.out.write(cArray, n2, n3);
    }

    @Override
    public void write(String string) {
        this.out.write(string);
    }

    @Override
    public void write(String string, int n2, int n3) {
        this.out.write(string, n2, n3);
    }

    @Override
    public void flush() {
        this.out.flush();
    }
}

