/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.io.monitor.FileAlterationObserver;

public final class FileAlterationMonitor
implements Runnable {
    private final long interval;
    private final List observers = new CopyOnWriteArrayList();
    private Thread thread = null;
    private ThreadFactory threadFactory;
    private volatile boolean running = false;

    public FileAlterationMonitor() {
        this(10000L);
    }

    public FileAlterationMonitor(long l2) {
        this.interval = l2;
    }

    public FileAlterationMonitor(long l2, FileAlterationObserver ... fileAlterationObserverArray) {
        this(l2);
        if (fileAlterationObserverArray != null) {
            FileAlterationObserver[] fileAlterationObserverArray2 = fileAlterationObserverArray;
            int n2 = fileAlterationObserverArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                FileAlterationObserver fileAlterationObserver = fileAlterationObserverArray2[i2];
                this.addObserver(fileAlterationObserver);
            }
        }
    }

    public final long getInterval() {
        return this.interval;
    }

    public final synchronized void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public final void addObserver(FileAlterationObserver fileAlterationObserver) {
        if (fileAlterationObserver != null) {
            this.observers.add(fileAlterationObserver);
        }
    }

    public final void removeObserver(FileAlterationObserver fileAlterationObserver) {
        if (fileAlterationObserver != null) {
            while (this.observers.remove(fileAlterationObserver)) {
            }
        }
    }

    public final Iterable getObservers() {
        return this.observers;
    }

    public final synchronized void start() {
        if (this.running) {
            throw new IllegalStateException("Monitor is already running");
        }
        for (FileAlterationObserver fileAlterationObserver : this.observers) {
            fileAlterationObserver.initialize();
        }
        this.running = true;
        this.thread = this.threadFactory != null ? this.threadFactory.newThread(this) : new Thread(this);
        this.thread.start();
    }

    public final synchronized void stop() {
        this.stop(this.interval);
    }

    public final synchronized void stop(long l2) {
        if (!this.running) {
            throw new IllegalStateException("Monitor is not running");
        }
        this.running = false;
        try {
            this.thread.join(l2);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        for (FileAlterationObserver fileAlterationObserver : this.observers) {
            fileAlterationObserver.destroy();
        }
    }

    @Override
    public final void run() {
        while (this.running) {
            for (FileAlterationObserver fileAlterationObserver : this.observers) {
                fileAlterationObserver.checkAndNotify();
            }
            if (!this.running) break;
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

