/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.io.input.XmlStreamReaderException;

public class XmlStreamReader
extends Reader {
    private static final int BUFFER_SIZE = 4096;
    private static final String UTF_8 = "UTF-8";
    private static final String US_ASCII = "US-ASCII";
    private static final String UTF_16BE = "UTF-16BE";
    private static final String UTF_16LE = "UTF-16LE";
    private static final String UTF_32BE = "UTF-32BE";
    private static final String UTF_32LE = "UTF-32LE";
    private static final String UTF_16 = "UTF-16";
    private static final String UTF_32 = "UTF-32";
    private static final String EBCDIC = "CP1047";
    private static final ByteOrderMark[] BOMS = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE};
    private static final ByteOrderMark[] XML_GUESS_BYTES = new ByteOrderMark[]{new ByteOrderMark("UTF-8", 60, 63, 120, 109), new ByteOrderMark("UTF-16BE", 0, 60, 0, 63), new ByteOrderMark("UTF-16LE", 60, 0, 63, 0), new ByteOrderMark("UTF-32BE", 0, 0, 0, 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 109), new ByteOrderMark("UTF-32LE", 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 109, 0, 0, 0), new ByteOrderMark("CP1047", 76, 111, 167, 148)};
    private final Reader reader;
    private final String encoding;
    private final String defaultEncoding;
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=[\"']?([.[^; \"']]*)[\"']?");
    public static final Pattern ENCODING_PATTERN = Pattern.compile("<\\?xml.*encoding[\\s]*=[\\s]*((?:\".[^\"]*\")|(?:'.[^']*'))", 8);
    private static final String RAW_EX_1 = "Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch";
    private static final String RAW_EX_2 = "Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] unknown BOM";
    private static final String HTTP_EX_1 = "Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], BOM must be NULL";
    private static final String HTTP_EX_2 = "Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], encoding mismatch";
    private static final String HTTP_EX_3 = "Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], Invalid MIME";

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public XmlStreamReader(File file) {
        this(new FileInputStream(file));
    }

    public XmlStreamReader(InputStream inputStream) {
        this(inputStream, true);
    }

    public XmlStreamReader(InputStream inputStream, boolean bl) {
        this(inputStream, bl, null);
    }

    public XmlStreamReader(InputStream inputStream, boolean bl, String object) {
        this.defaultEncoding = object;
        inputStream = new BOMInputStream((InputStream)new BufferedInputStream(inputStream, 4096), false, BOMS);
        object = new BOMInputStream(inputStream, true, XML_GUESS_BYTES);
        this.encoding = this.doRawStream((BOMInputStream)inputStream, (BOMInputStream)object, bl);
        this.reader = new InputStreamReader((InputStream)object, this.encoding);
    }

    public XmlStreamReader(URL uRL) {
        this(uRL.openConnection(), null);
    }

    public XmlStreamReader(URLConnection uRLConnection, String string) {
        this.defaultEncoding = string;
        string = uRLConnection.getContentType();
        InputStream inputStream = uRLConnection.getInputStream();
        inputStream = new BOMInputStream((InputStream)new BufferedInputStream(inputStream, 4096), false, BOMS);
        BOMInputStream bOMInputStream = new BOMInputStream(inputStream, true, XML_GUESS_BYTES);
        this.encoding = uRLConnection instanceof HttpURLConnection || string != null ? this.doHttpStream((BOMInputStream)inputStream, bOMInputStream, string, true) : this.doRawStream((BOMInputStream)inputStream, bOMInputStream, true);
        this.reader = new InputStreamReader((InputStream)bOMInputStream, this.encoding);
    }

    public XmlStreamReader(InputStream inputStream, String string) {
        this(inputStream, string, true);
    }

    public XmlStreamReader(InputStream inputStream, String string, boolean bl, String object) {
        this.defaultEncoding = object;
        inputStream = new BOMInputStream((InputStream)new BufferedInputStream(inputStream, 4096), false, BOMS);
        object = new BOMInputStream(inputStream, true, XML_GUESS_BYTES);
        this.encoding = this.doHttpStream((BOMInputStream)inputStream, (BOMInputStream)object, string, bl);
        this.reader = new InputStreamReader((InputStream)object, this.encoding);
    }

    public XmlStreamReader(InputStream inputStream, String string, boolean bl) {
        this(inputStream, string, bl, null);
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        return this.reader.read(cArray, n2, n3);
    }

    @Override
    public void close() {
        this.reader.close();
    }

    private String doRawStream(BOMInputStream object, BOMInputStream object2, boolean bl) {
        object = ((BOMInputStream)object).getBOMCharsetName();
        String string = ((BOMInputStream)object2).getBOMCharsetName();
        object2 = XmlStreamReader.getXmlProlog((InputStream)object2, string);
        try {
            return this.calculateRawEncoding((String)object, string, (String)object2);
        }
        catch (XmlStreamReaderException xmlStreamReaderException) {
            if (bl) {
                return this.doLenientDetection(null, xmlStreamReaderException);
            }
            throw xmlStreamReaderException;
        }
    }

    private String doHttpStream(BOMInputStream object, BOMInputStream object2, String string, boolean bl) {
        object = ((BOMInputStream)object).getBOMCharsetName();
        String string2 = ((BOMInputStream)object2).getBOMCharsetName();
        object2 = XmlStreamReader.getXmlProlog((InputStream)object2, string2);
        try {
            return this.calculateHttpEncoding(string, (String)object, string2, (String)object2, bl);
        }
        catch (XmlStreamReaderException xmlStreamReaderException) {
            if (bl) {
                return this.doLenientDetection(string, xmlStreamReaderException);
            }
            throw xmlStreamReaderException;
        }
    }

    private String doLenientDetection(String object, XmlStreamReaderException xmlStreamReaderException) {
        if (object != null && ((String)object).startsWith("text/html")) {
            object = ((String)object).substring("text/html".length());
            object = "text/xml" + (String)object;
            try {
                return this.calculateHttpEncoding((String)object, xmlStreamReaderException.getBomEncoding(), xmlStreamReaderException.getXmlGuessEncoding(), xmlStreamReaderException.getXmlEncoding(), true);
            }
            catch (XmlStreamReaderException xmlStreamReaderException2) {
                object = xmlStreamReaderException2;
                xmlStreamReaderException = xmlStreamReaderException2;
            }
        }
        if ((object = xmlStreamReaderException.getXmlEncoding()) == null) {
            object = xmlStreamReaderException.getContentTypeEncoding();
        }
        if (object == null) {
            object = this.defaultEncoding == null ? UTF_8 : this.defaultEncoding;
        }
        return object;
    }

    private String calculateRawEncoding(String string, String string2, String string3) {
        if (string == null) {
            if (string2 == null || string3 == null) {
                if (this.defaultEncoding == null) {
                    return UTF_8;
                }
                return this.defaultEncoding;
            }
            if (string3.equals(UTF_16) && (string2.equals(UTF_16BE) || string2.equals(UTF_16LE))) {
                return string2;
            }
            return string3;
        }
        if (string.equals(UTF_8)) {
            if (string2 != null && !string2.equals(UTF_8)) {
                String string4 = MessageFormat.format(RAW_EX_1, string, string2, string3);
                throw new XmlStreamReaderException(string4, string, string2, string3);
            }
            if (string3 != null && !string3.equals(UTF_8)) {
                String string5 = MessageFormat.format(RAW_EX_1, string, string2, string3);
                throw new XmlStreamReaderException(string5, string, string2, string3);
            }
            return string;
        }
        if (string.equals(UTF_16BE) || string.equals(UTF_16LE)) {
            if (string2 != null && !string2.equals(string)) {
                String string6 = MessageFormat.format(RAW_EX_1, string, string2, string3);
                throw new XmlStreamReaderException(string6, string, string2, string3);
            }
            if (string3 != null && !string3.equals(UTF_16) && !string3.equals(string)) {
                String string7 = MessageFormat.format(RAW_EX_1, string, string2, string3);
                throw new XmlStreamReaderException(string7, string, string2, string3);
            }
            return string;
        }
        if (string.equals(UTF_32BE) || string.equals(UTF_32LE)) {
            if (string2 != null && !string2.equals(string)) {
                String string8 = MessageFormat.format(RAW_EX_1, string, string2, string3);
                throw new XmlStreamReaderException(string8, string, string2, string3);
            }
            if (string3 != null && !string3.equals(UTF_32) && !string3.equals(string)) {
                String string9 = MessageFormat.format(RAW_EX_1, string, string2, string3);
                throw new XmlStreamReaderException(string9, string, string2, string3);
            }
            return string;
        }
        String string10 = MessageFormat.format(RAW_EX_2, string, string2, string3);
        throw new XmlStreamReaderException(string10, string, string2, string3);
    }

    private String calculateHttpEncoding(String object, String string, String string2, String string3, boolean bl) {
        boolean bl2;
        int n2;
        if (bl && string3 != null) {
            return string3;
        }
        String string4 = object;
        String string5 = null;
        if (string4 != null) {
            n2 = string4.indexOf(";");
            string5 = n2 >= 0 ? string4.substring(0, n2) : string4;
            string5 = string5.trim();
        }
        String string6 = string5;
        string4 = object;
        string5 = null;
        if (string4 != null && (n2 = string4.indexOf(";")) >= 0) {
            object = string4.substring(n2 + 1);
            string5 = ((Matcher)(object = CHARSET_PATTERN.matcher((CharSequence)object))).find() ? ((Matcher)object).group(1) : null;
            string5 = string5 != null ? string5.toUpperCase(Locale.US) : null;
        }
        object = string5;
        string4 = string6;
        boolean bl3 = string4 != null && (string4.equals("application/xml") || string4.equals("application/xml-dtd") || string4.equals("application/xml-external-parsed-entity") || string4.startsWith("application/") && string4.endsWith("+xml"));
        string4 = string6;
        boolean bl4 = bl2 = string4 != null && (string4.equals("text/xml") || string4.equals("text/xml-external-parsed-entity") || string4.startsWith("text/") && string4.endsWith("+xml"));
        if (!bl3 && !bl2) {
            String string7 = MessageFormat.format(HTTP_EX_3, string6, object, string, string2, string3);
            throw new XmlStreamReaderException(string7, string6, (String)object, string, string2, string3);
        }
        if (object == null) {
            if (bl3) {
                return this.calculateRawEncoding(string, string2, string3);
            }
            if (this.defaultEncoding == null) {
                return US_ASCII;
            }
            return this.defaultEncoding;
        }
        if (((String)object).equals(UTF_16BE) || ((String)object).equals(UTF_16LE)) {
            if (string != null) {
                String string8 = MessageFormat.format(HTTP_EX_1, string6, object, string, string2, string3);
                throw new XmlStreamReaderException(string8, string6, (String)object, string, string2, string3);
            }
            return object;
        }
        if (((String)object).equals(UTF_16)) {
            if (string != null && string.startsWith(UTF_16)) {
                return string;
            }
            String string9 = MessageFormat.format(HTTP_EX_2, string6, object, string, string2, string3);
            throw new XmlStreamReaderException(string9, string6, (String)object, string, string2, string3);
        }
        if (((String)object).equals(UTF_32BE) || ((String)object).equals(UTF_32LE)) {
            if (string != null) {
                String string10 = MessageFormat.format(HTTP_EX_1, string6, object, string, string2, string3);
                throw new XmlStreamReaderException(string10, string6, (String)object, string, string2, string3);
            }
            return object;
        }
        if (((String)object).equals(UTF_32)) {
            if (string != null && string.startsWith(UTF_32)) {
                return string;
            }
            String string11 = MessageFormat.format(HTTP_EX_2, string6, object, string, string2, string3);
            throw new XmlStreamReaderException(string11, string6, (String)object, string, string2, string3);
        }
        return object;
    }

    private static String getContentTypeMime(String string) {
        String string2 = null;
        if (string != null) {
            int n2 = string.indexOf(";");
            string2 = n2 >= 0 ? string.substring(0, n2) : string;
            string2 = string2.trim();
        }
        return string2;
    }

    private static String getContentTypeEncoding(String object) {
        int n2;
        String string = null;
        if (object != null && (n2 = ((String)object).indexOf(";")) >= 0) {
            object = ((String)object).substring(n2 + 1);
            string = ((Matcher)(object = CHARSET_PATTERN.matcher((CharSequence)object))).find() ? ((Matcher)object).group(1) : null;
            string = string != null ? string.toUpperCase(Locale.US) : null;
        }
        return string;
    }

    private static String getXmlProlog(InputStream object, String string) {
        String string2 = null;
        if (string != null) {
            Object object2 = new byte[4096];
            ((InputStream)object).mark(4096);
            int n2 = 0;
            int n3 = 4096;
            int n4 = ((InputStream)object).read((byte[])object2, 0, 4096);
            int n5 = -1;
            String string3 = null;
            while (n4 != -1 && n5 == -1 && n2 < 4096) {
                n4 = ((InputStream)object).read((byte[])object2, n2 += n4, n3 -= n4);
                string3 = new String((byte[])object2, 0, n2, string);
                n5 = string3.indexOf(62);
            }
            if (n5 == -1) {
                if (n4 == -1) {
                    throw new IOException("Unexpected end of XML stream");
                }
                throw new IOException("XML prolog or ROOT element not found on first " + n2 + " bytes");
            }
            int n6 = n2;
            if (n6 > 0) {
                ((InputStream)object).reset();
                object = new BufferedReader(new StringReader(string3.substring(0, n5 + 1)));
                StringBuffer stringBuffer = new StringBuffer();
                object2 = ((BufferedReader)object).readLine();
                while (object2 != null) {
                    stringBuffer.append((String)object2);
                    object2 = ((BufferedReader)object).readLine();
                }
                object = ENCODING_PATTERN.matcher(stringBuffer);
                if (((Matcher)object).find()) {
                    string2 = ((Matcher)object).group(1).toUpperCase();
                    string2 = string2.substring(1, string2.length() - 1);
                }
            }
        }
        return string2;
    }

    private static boolean isAppXml(String string) {
        return string != null && (string.equals("application/xml") || string.equals("application/xml-dtd") || string.equals("application/xml-external-parsed-entity") || string.startsWith("application/") && string.endsWith("+xml"));
    }

    private static boolean isTextXml(String string) {
        return string != null && (string.equals("text/xml") || string.equals("text/xml-external-parsed-entity") || string.startsWith("text/") && string.endsWith("+xml"));
    }
}

