/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.TailerListener;

public class Tailer
implements Runnable {
    private static final int DEFAULT_DELAY_MILLIS = 1000;
    private static final String RAF_MODE = "r";
    private static final int DEFAULT_BUFSIZE = 4096;
    private final byte[] inbuf;
    private final File file;
    private final long delayMillis;
    private final boolean end;
    private final TailerListener listener;
    private final boolean reOpen;
    private volatile boolean run = true;

    public Tailer(File file, TailerListener tailerListener) {
        this(file, tailerListener, 1000L);
    }

    public Tailer(File file, TailerListener tailerListener, long l2) {
        this(file, tailerListener, l2, false);
    }

    public Tailer(File file, TailerListener tailerListener, long l2, boolean bl) {
        this(file, tailerListener, l2, bl, 4096);
    }

    public Tailer(File file, TailerListener tailerListener, long l2, boolean bl, boolean bl2) {
        this(file, tailerListener, l2, bl, bl2, 4096);
    }

    public Tailer(File file, TailerListener tailerListener, long l2, boolean bl, int n2) {
        this(file, tailerListener, l2, bl, false, n2);
    }

    public Tailer(File file, TailerListener tailerListener, long l2, boolean bl, boolean bl2, int n2) {
        this.file = file;
        this.delayMillis = l2;
        this.end = bl;
        this.inbuf = new byte[n2];
        this.listener = tailerListener;
        tailerListener.init(this);
        this.reOpen = bl2;
    }

    public static Tailer create(File object, TailerListener object2, long l2, boolean bl, int n2) {
        object = new Tailer((File)object, (TailerListener)object2, l2, bl, n2);
        object2 = new Thread((Runnable)object);
        ((Thread)object2).setDaemon(true);
        ((Thread)object2).start();
        return object;
    }

    public static Tailer create(File object, TailerListener object2, long l2, boolean bl, boolean bl2, int n2) {
        object = new Tailer((File)object, (TailerListener)object2, l2, bl, bl2, n2);
        object2 = new Thread((Runnable)object);
        ((Thread)object2).setDaemon(true);
        ((Thread)object2).start();
        return object;
    }

    public static Tailer create(File file, TailerListener tailerListener, long l2, boolean bl) {
        return Tailer.create(file, tailerListener, l2, bl, 4096);
    }

    public static Tailer create(File file, TailerListener tailerListener, long l2, boolean bl, boolean bl2) {
        return Tailer.create(file, tailerListener, l2, bl, bl2, 4096);
    }

    public static Tailer create(File file, TailerListener tailerListener, long l2) {
        return Tailer.create(file, tailerListener, l2, false);
    }

    public static Tailer create(File file, TailerListener tailerListener) {
        return Tailer.create(file, tailerListener, 1000L, false);
    }

    public File getFile() {
        return this.file;
    }

    public long getDelay() {
        return this.delayMillis;
    }

    @Override
    public void run() {
        RandomAccessFile randomAccessFile = null;
        try {
            long l2 = 0L;
            long l3 = 0L;
            while (this.run && randomAccessFile == null) {
                try {
                    randomAccessFile = new RandomAccessFile(this.file, RAF_MODE);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.listener.fileNotFound();
                }
                if (randomAccessFile == null) {
                    try {
                        Thread.sleep(this.delayMillis);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                l3 = this.end ? this.file.length() : 0L;
                l2 = System.currentTimeMillis();
                randomAccessFile.seek(l3);
            }
            while (this.run) {
                boolean bl = FileUtils.isFileNewer(this.file, l2);
                long l4 = this.file.length();
                if (l4 < l3) {
                    this.listener.fileRotated();
                    try {
                        RandomAccessFile randomAccessFile2 = randomAccessFile;
                        randomAccessFile = new RandomAccessFile(this.file, RAF_MODE);
                        l3 = 0L;
                        IOUtils.closeQuietly(randomAccessFile2);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.listener.fileNotFound();
                    }
                    continue;
                }
                if (l4 > l3) {
                    l3 = this.readLines(randomAccessFile);
                    l2 = System.currentTimeMillis();
                } else if (bl) {
                    randomAccessFile.seek(0L);
                    l3 = this.readLines(randomAccessFile);
                    l2 = System.currentTimeMillis();
                }
                if (this.reOpen) {
                    IOUtils.closeQuietly(randomAccessFile);
                }
                try {
                    Thread.sleep(this.delayMillis);
                }
                catch (InterruptedException interruptedException) {}
                if (!this.run || !this.reOpen) continue;
                randomAccessFile = new RandomAccessFile(this.file, RAF_MODE);
                randomAccessFile.seek(l3);
            }
            return;
        }
        catch (Exception exception) {
            this.listener.handle(exception);
            return;
        }
        finally {
            IOUtils.closeQuietly(randomAccessFile);
        }
    }

    public void stop() {
        this.run = false;
    }

    private long readLines(RandomAccessFile randomAccessFile) {
        int n2;
        long l2;
        StringBuilder stringBuilder = new StringBuilder();
        long l3 = l2 = randomAccessFile.getFilePointer();
        boolean bl = false;
        while (this.run && (n2 = randomAccessFile.read(this.inbuf)) != -1) {
            block5: for (int i2 = 0; i2 < n2; ++i2) {
                byte by = this.inbuf[i2];
                switch (by) {
                    case 10: {
                        bl = false;
                        this.listener.handle(stringBuilder.toString());
                        stringBuilder.setLength(0);
                        l3 = l2 + (long)i2 + 1L;
                        continue block5;
                    }
                    case 13: {
                        if (bl) {
                            stringBuilder.append('\r');
                        }
                        bl = true;
                        continue block5;
                    }
                    default: {
                        if (bl) {
                            bl = false;
                            this.listener.handle(stringBuilder.toString());
                            stringBuilder.setLength(0);
                            l3 = l2 + (long)i2 + 1L;
                        }
                        stringBuilder.append((char)by);
                    }
                }
            }
            l2 = randomAccessFile.getFilePointer();
        }
        randomAccessFile.seek(l3);
        return l3;
    }
}

