/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DelegateFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.MagicNumberFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.SizeFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class FileFilterUtils {
    private static final IOFileFilter cvsFilter = FileFilterUtils.notFileFilter(FileFilterUtils.and(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter("CVS")));
    private static final IOFileFilter svnFilter = FileFilterUtils.notFileFilter(FileFilterUtils.and(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter(".svn")));

    public static File[] filter(IOFileFilter iOFileFilter, File ... fileArray) {
        if (iOFileFilter == null) {
            throw new IllegalArgumentException("file filter is null");
        }
        if (fileArray == null) {
            return new File[0];
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : fileArray) {
            if (file == null) {
                throw new IllegalArgumentException("file array contains null");
            }
            if (!iOFileFilter.accept(file)) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static File[] filter(IOFileFilter object, Iterable iterable) {
        object = FileFilterUtils.filterList((IOFileFilter)object, iterable);
        return object.toArray(new File[object.size()]);
    }

    public static List filterList(IOFileFilter iOFileFilter, Iterable iterable) {
        return (List)FileFilterUtils.filter(iOFileFilter, iterable, new ArrayList());
    }

    public static List filterList(IOFileFilter fileArray, File ... fileArray2) {
        fileArray = FileFilterUtils.filter((IOFileFilter)fileArray, fileArray2);
        return Arrays.asList(fileArray);
    }

    public static Set filterSet(IOFileFilter fileArray, File ... fileArray2) {
        fileArray = FileFilterUtils.filter((IOFileFilter)fileArray, fileArray2);
        return new HashSet<File>(Arrays.asList(fileArray));
    }

    public static Set filterSet(IOFileFilter iOFileFilter, Iterable iterable) {
        return (Set)FileFilterUtils.filter(iOFileFilter, iterable, new HashSet());
    }

    private static Collection filter(IOFileFilter iOFileFilter, Iterable object, Collection collection) {
        if (iOFileFilter == null) {
            throw new IllegalArgumentException("file filter is null");
        }
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                File file = (File)object.next();
                if (file == null) {
                    throw new IllegalArgumentException("file collection contains null");
                }
                if (!iOFileFilter.accept(file)) continue;
                collection.add(file);
            }
        }
        return collection;
    }

    public static IOFileFilter prefixFileFilter(String string) {
        return new PrefixFileFilter(string);
    }

    public static IOFileFilter prefixFileFilter(String string, IOCase iOCase) {
        return new PrefixFileFilter(string, iOCase);
    }

    public static IOFileFilter suffixFileFilter(String string) {
        return new SuffixFileFilter(string);
    }

    public static IOFileFilter suffixFileFilter(String string, IOCase iOCase) {
        return new SuffixFileFilter(string, iOCase);
    }

    public static IOFileFilter nameFileFilter(String string) {
        return new NameFileFilter(string);
    }

    public static IOFileFilter nameFileFilter(String string, IOCase iOCase) {
        return new NameFileFilter(string, iOCase);
    }

    public static IOFileFilter directoryFileFilter() {
        return DirectoryFileFilter.DIRECTORY;
    }

    public static IOFileFilter fileFileFilter() {
        return FileFileFilter.FILE;
    }

    public static IOFileFilter andFileFilter(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return new AndFileFilter(iOFileFilter, iOFileFilter2);
    }

    public static IOFileFilter orFileFilter(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return new OrFileFilter(iOFileFilter, iOFileFilter2);
    }

    public static IOFileFilter and(IOFileFilter ... iOFileFilterArray) {
        return new AndFileFilter(FileFilterUtils.toList(iOFileFilterArray));
    }

    public static IOFileFilter or(IOFileFilter ... iOFileFilterArray) {
        return new OrFileFilter(FileFilterUtils.toList(iOFileFilterArray));
    }

    public static List toList(IOFileFilter ... iOFileFilterArray) {
        if (iOFileFilterArray == null) {
            throw new IllegalArgumentException("The filters must not be null");
        }
        ArrayList<IOFileFilter> arrayList = new ArrayList<IOFileFilter>(iOFileFilterArray.length);
        for (int i2 = 0; i2 < iOFileFilterArray.length; ++i2) {
            if (iOFileFilterArray[i2] == null) {
                throw new IllegalArgumentException("The filter[" + i2 + "] is null");
            }
            arrayList.add(iOFileFilterArray[i2]);
        }
        return arrayList;
    }

    public static IOFileFilter notFileFilter(IOFileFilter iOFileFilter) {
        return new NotFileFilter(iOFileFilter);
    }

    public static IOFileFilter trueFileFilter() {
        return TrueFileFilter.TRUE;
    }

    public static IOFileFilter falseFileFilter() {
        return FalseFileFilter.FALSE;
    }

    public static IOFileFilter asFileFilter(FileFilter fileFilter) {
        return new DelegateFileFilter(fileFilter);
    }

    public static IOFileFilter asFileFilter(FilenameFilter filenameFilter) {
        return new DelegateFileFilter(filenameFilter);
    }

    public static IOFileFilter ageFileFilter(long l2) {
        return new AgeFileFilter(l2);
    }

    public static IOFileFilter ageFileFilter(long l2, boolean bl) {
        return new AgeFileFilter(l2, bl);
    }

    public static IOFileFilter ageFileFilter(Date date) {
        return new AgeFileFilter(date);
    }

    public static IOFileFilter ageFileFilter(Date date, boolean bl) {
        return new AgeFileFilter(date, bl);
    }

    public static IOFileFilter ageFileFilter(File file) {
        return new AgeFileFilter(file);
    }

    public static IOFileFilter ageFileFilter(File file, boolean bl) {
        return new AgeFileFilter(file, bl);
    }

    public static IOFileFilter sizeFileFilter(long l2) {
        return new SizeFileFilter(l2);
    }

    public static IOFileFilter sizeFileFilter(long l2, boolean bl) {
        return new SizeFileFilter(l2, bl);
    }

    public static IOFileFilter sizeRangeFileFilter(long l2, long l3) {
        SizeFileFilter sizeFileFilter = new SizeFileFilter(l2, true);
        SizeFileFilter sizeFileFilter2 = new SizeFileFilter(l3 + 1L, false);
        return new AndFileFilter(sizeFileFilter, sizeFileFilter2);
    }

    public static IOFileFilter magicNumberFileFilter(String string) {
        return new MagicNumberFileFilter(string);
    }

    public static IOFileFilter magicNumberFileFilter(String string, long l2) {
        return new MagicNumberFileFilter(string, l2);
    }

    public static IOFileFilter magicNumberFileFilter(byte[] byArray) {
        return new MagicNumberFileFilter(byArray);
    }

    public static IOFileFilter magicNumberFileFilter(byte[] byArray, long l2) {
        return new MagicNumberFileFilter(byArray, l2);
    }

    public static IOFileFilter makeCVSAware(IOFileFilter iOFileFilter) {
        if (iOFileFilter == null) {
            return cvsFilter;
        }
        return FileFilterUtils.and(iOFileFilter, cvsFilter);
    }

    public static IOFileFilter makeSVNAware(IOFileFilter iOFileFilter) {
        if (iOFileFilter == null) {
            return svnFilter;
        }
        return FileFilterUtils.and(iOFileFilter, svnFilter);
    }

    public static IOFileFilter makeDirectoryOnly(IOFileFilter iOFileFilter) {
        if (iOFileFilter == null) {
            return DirectoryFileFilter.DIRECTORY;
        }
        return new AndFileFilter(DirectoryFileFilter.DIRECTORY, iOFileFilter);
    }

    public static IOFileFilter makeFileOnly(IOFileFilter iOFileFilter) {
        if (iOFileFilter == null) {
            return FileFileFilter.FILE;
        }
        return new AndFileFilter(FileFileFilter.FILE, iOFileFilter);
    }
}

