/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import org.apache.commons.io.IOCase;

public class FilenameUtils {
    public static final char EXTENSION_SEPARATOR = '.';
    public static final String EXTENSION_SEPARATOR_STR = Character.toString('.');
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final char OTHER_SEPARATOR = FilenameUtils.a() ? (char)47 : (char)92;

    static boolean a() {
        return SYSTEM_SEPARATOR == '\\';
    }

    private static boolean isSeparator(char c2) {
        return c2 == '/' || c2 == '\\';
    }

    public static String normalize(String string) {
        return FilenameUtils.doNormalize(string, SYSTEM_SEPARATOR, true);
    }

    public static String normalize(String string, boolean bl) {
        char c2 = bl ? (char)'/' : '\\';
        return FilenameUtils.doNormalize(string, c2, true);
    }

    public static String normalizeNoEndSeparator(String string) {
        return FilenameUtils.doNormalize(string, SYSTEM_SEPARATOR, false);
    }

    public static String normalizeNoEndSeparator(String string, boolean bl) {
        char c2 = bl ? (char)'/' : '\\';
        return FilenameUtils.doNormalize(string, c2, false);
    }

    private static String doNormalize(String string, char c2, boolean bl) {
        int n2;
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        if (n3 == 0) {
            return string;
        }
        int n4 = FilenameUtils.getPrefixLength(string);
        if (n4 < 0) {
            return null;
        }
        char[] cArray = new char[n3 + 2];
        string.getChars(0, string.length(), cArray, 0);
        int n5 = c2 == SYSTEM_SEPARATOR ? OTHER_SEPARATOR : SYSTEM_SEPARATOR;
        for (n2 = 0; n2 < cArray.length; ++n2) {
            if (cArray[n2] != n5) continue;
            cArray[n2] = c2;
        }
        n2 = 1;
        if (cArray[n3 - 1] != c2) {
            cArray[n3++] = c2;
            n2 = 0;
        }
        for (n5 = n4 + 1; n5 < n3; ++n5) {
            if (cArray[n5] != c2 || cArray[n5 - 1] != c2) continue;
            System.arraycopy(cArray, n5, cArray, n5 - 1, n3 - n5);
            --n3;
            --n5;
        }
        for (n5 = n4 + 1; n5 < n3; ++n5) {
            if (cArray[n5] != c2 || cArray[n5 - 1] != '.' || n5 != n4 + 1 && cArray[n5 - 2] != c2) continue;
            if (n5 == n3 - 1) {
                n2 = 1;
            }
            System.arraycopy(cArray, n5 + 1, cArray, n5 - 1, n3 - n5);
            n3 -= 2;
            --n5;
        }
        block3: for (n5 = n4 + 2; n5 < n3; ++n5) {
            if (cArray[n5] != c2 || cArray[n5 - 1] != '.' || cArray[n5 - 2] != '.' || n5 != n4 + 2 && cArray[n5 - 3] != c2) continue;
            if (n5 == n4 + 2) {
                return null;
            }
            if (n5 == n3 - 1) {
                n2 = 1;
            }
            for (int i2 = n5 - 4; i2 >= n4; --i2) {
                if (cArray[i2] != c2) continue;
                System.arraycopy(cArray, n5 + 1, cArray, i2 + 1, n3 - n5);
                n3 -= n5 - i2;
                n5 = i2 + 1;
                continue block3;
            }
            System.arraycopy(cArray, n5 + 1, cArray, n4, n3 - n5);
            n3 -= n5 + 1 - n4;
            n5 = n4 + 1;
        }
        if (n3 <= 0) {
            return "";
        }
        if (n3 <= n4) {
            return new String(cArray, 0, n3);
        }
        if (n2 != 0 && bl) {
            return new String(cArray, 0, n3);
        }
        return new String(cArray, 0, n3 - 1);
    }

    public static String concat(String string, String string2) {
        int n2 = FilenameUtils.getPrefixLength(string2);
        if (n2 < 0) {
            return null;
        }
        if (n2 > 0) {
            return FilenameUtils.normalize(string2);
        }
        if (string == null) {
            return null;
        }
        n2 = string.length();
        if (n2 == 0) {
            return FilenameUtils.normalize(string2);
        }
        char c2 = string.charAt(n2 - 1);
        n2 = c2;
        if (FilenameUtils.isSeparator(c2)) {
            return FilenameUtils.normalize(string + string2);
        }
        return FilenameUtils.normalize(string + '/' + string2);
    }

    public static boolean directoryContains(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Directory must not be null");
        }
        if (string2 == null) {
            return false;
        }
        if (IOCase.SYSTEM.checkEquals(string, string2)) {
            return false;
        }
        return IOCase.SYSTEM.checkStartsWith(string2, string);
    }

    public static String separatorsToUnix(String string) {
        if (string == null || string.indexOf(92) == -1) {
            return string;
        }
        return string.replace('\\', '/');
    }

    public static String separatorsToWindows(String string) {
        if (string == null || string.indexOf(47) == -1) {
            return string;
        }
        return string.replace('/', '\\');
    }

    public static String separatorsToSystem(String string) {
        if (string == null) {
            return null;
        }
        if (FilenameUtils.a()) {
            return FilenameUtils.separatorsToWindows(string);
        }
        return FilenameUtils.separatorsToUnix(string);
    }

    public static int getPrefixLength(String string) {
        if (string == null) {
            return -1;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return 0;
        }
        int n3 = string.charAt(0);
        if (n3 == 58) {
            return -1;
        }
        if (n2 == 1) {
            if (n3 == 126) {
                return 2;
            }
            if (FilenameUtils.isSeparator((char)n3)) {
                return 1;
            }
            return 0;
        }
        if (n3 == 126) {
            int n4 = string.indexOf(47, 1);
            n3 = string.indexOf(92, 1);
            if (n4 == -1 && n3 == -1) {
                return n2 + 1;
            }
            n4 = n4 == -1 ? n3 : n4;
            n3 = n3 == -1 ? n4 : n3;
            return Math.min(n4, n3) + 1;
        }
        char c2 = string.charAt(1);
        if (c2 == ':') {
            char c3 = Character.toUpperCase((char)n3);
            n3 = c3;
            if (c3 >= 'A' && n3 <= 90) {
                if (n2 == 2 || !FilenameUtils.isSeparator(string.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            return -1;
        }
        if (FilenameUtils.isSeparator((char)n3) && FilenameUtils.isSeparator(c2)) {
            n3 = string.indexOf(47, 2);
            int n5 = string.indexOf(92, 2);
            if (n3 == -1 && n5 == -1 || n3 == 2 || n5 == 2) {
                return -1;
            }
            n3 = n3 == -1 ? n5 : n3;
            n5 = n5 == -1 ? n3 : n5;
            return Math.min(n3, n5) + 1;
        }
        if (FilenameUtils.isSeparator((char)n3)) {
            return 1;
        }
        return 0;
    }

    public static int indexOfLastSeparator(String string) {
        if (string == null) {
            return -1;
        }
        int n2 = string.lastIndexOf(47);
        int n3 = string.lastIndexOf(92);
        return Math.max(n2, n3);
    }

    public static int indexOfExtension(String string) {
        if (string == null) {
            return -1;
        }
        int n2 = string.lastIndexOf(46);
        int n3 = FilenameUtils.indexOfLastSeparator(string);
        if (n3 > n2) {
            return -1;
        }
        return n2;
    }

    public static String getPrefix(String string) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.getPrefixLength(string);
        if (n2 < 0) {
            return null;
        }
        if (n2 > string.length()) {
            return string + '/';
        }
        return string.substring(0, n2);
    }

    public static String getPath(String string) {
        return FilenameUtils.doGetPath(string, 1);
    }

    public static String getPathNoEndSeparator(String string) {
        return FilenameUtils.doGetPath(string, 0);
    }

    private static String doGetPath(String string, int n2) {
        if (string == null) {
            return null;
        }
        int n3 = FilenameUtils.getPrefixLength(string);
        if (n3 < 0) {
            return null;
        }
        int n4 = FilenameUtils.indexOfLastSeparator(string);
        n2 = n4 + n2;
        if (n3 >= string.length() || n4 < 0 || n3 >= n2) {
            return "";
        }
        return string.substring(n3, n2);
    }

    public static String getFullPath(String string) {
        return FilenameUtils.doGetFullPath(string, true);
    }

    public static String getFullPathNoEndSeparator(String string) {
        return FilenameUtils.doGetFullPath(string, false);
    }

    private static String doGetFullPath(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.getPrefixLength(string);
        if (n2 < 0) {
            return null;
        }
        if (n2 >= string.length()) {
            if (bl) {
                return FilenameUtils.getPrefix(string);
            }
            return string;
        }
        int n3 = FilenameUtils.indexOfLastSeparator(string);
        if (n3 < 0) {
            return string.substring(0, n2);
        }
        if (!(bl = n3 + (bl ? 1 : 0))) {
            bl += 1;
        }
        return string.substring(0, bl ? 1 : 0);
    }

    public static String getName(String string) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.indexOfLastSeparator(string);
        return string.substring(n2 + 1);
    }

    public static String getBaseName(String string) {
        return FilenameUtils.removeExtension(FilenameUtils.getName(string));
    }

    public static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.indexOfExtension(string);
        if (n2 == -1) {
            return "";
        }
        return string.substring(n2 + 1);
    }

    public static String removeExtension(String string) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.indexOfExtension(string);
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static boolean equals(String string, String string2) {
        return FilenameUtils.equals(string, string2, false, IOCase.SENSITIVE);
    }

    public static boolean equalsOnSystem(String string, String string2) {
        return FilenameUtils.equals(string, string2, false, IOCase.SYSTEM);
    }

    public static boolean equalsNormalized(String string, String string2) {
        return FilenameUtils.equals(string, string2, true, IOCase.SENSITIVE);
    }

    public static boolean equalsNormalizedOnSystem(String string, String string2) {
        return FilenameUtils.equals(string, string2, true, IOCase.SYSTEM);
    }

    public static boolean equals(String string, String string2, boolean bl, IOCase iOCase) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        if (bl) {
            string = FilenameUtils.normalize(string);
            string2 = FilenameUtils.normalize(string2);
            if (string == null || string2 == null) {
                throw new NullPointerException("Error normalizing one or both of the file names");
            }
        }
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        return iOCase.checkEquals(string, string2);
    }

    public static boolean isExtension(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return FilenameUtils.indexOfExtension(string) == -1;
        }
        string = FilenameUtils.getExtension(string);
        return string.equals(string2);
    }

    public static boolean isExtension(String string, String[] stringArray) {
        if (string == null) {
            return false;
        }
        if (stringArray == null || stringArray.length == 0) {
            return FilenameUtils.indexOfExtension(string) == -1;
        }
        string = FilenameUtils.getExtension(string);
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtension(String string, Collection object) {
        if (string == null) {
            return false;
        }
        if (object == null || object.isEmpty()) {
            return FilenameUtils.indexOfExtension(string) == -1;
        }
        string = FilenameUtils.getExtension(string);
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean wildcardMatch(String string, String string2) {
        return FilenameUtils.wildcardMatch(string, string2, IOCase.SENSITIVE);
    }

    public static boolean wildcardMatchOnSystem(String string, String string2) {
        return FilenameUtils.wildcardMatch(string, string2, IOCase.SYSTEM);
    }

    public static boolean wildcardMatch(String string, String stringArray, IOCase iOCase) {
        int n2;
        String[] stringArray2;
        if (string == null && stringArray == null) {
            return true;
        }
        if (string == null || stringArray == null) {
            return false;
        }
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        if (stringArray.indexOf(63) == -1 && stringArray.indexOf(42) == -1) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = stringArray;
        } else {
            stringArray = (String[])stringArray.toCharArray();
            ArrayList<String> arrayList = new ArrayList<String>();
            StringBuilder stringBuilder = new StringBuilder();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (stringArray[n2] == 63 || stringArray[n2] == 42) {
                    if (stringBuilder.length() != 0) {
                        arrayList.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                    }
                    if (stringArray[n2] == 63) {
                        arrayList.add("?");
                        continue;
                    }
                    if (!arrayList.isEmpty() && (n2 <= 0 || ((String)arrayList.get(arrayList.size() - 1)).equals("*"))) continue;
                    arrayList.add("*");
                    continue;
                }
                stringBuilder.append((char)stringArray[n2]);
            }
            if (stringBuilder.length() != 0) {
                arrayList.add(stringBuilder.toString());
            }
            stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        }
        stringArray = stringArray2;
        int n3 = 0;
        int n4 = 0;
        n2 = 0;
        Stack<int[]> stack = new Stack<int[]>();
        do {
            if (stack.size() > 0) {
                int[] nArray = (int[])stack.pop();
                n2 = nArray[0];
                n4 = nArray[1];
                n3 = 1;
            }
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals("?")) {
                    if (++n4 > string.length()) break;
                    n3 = 0;
                } else if (stringArray[n2].equals("*")) {
                    n3 = 1;
                    if (n2 == stringArray.length - 1) {
                        n4 = string.length();
                    }
                } else {
                    if (n3 != 0) {
                        if ((n4 = iOCase.checkIndexOf(string, n4, stringArray[n2])) == -1) break;
                        n3 = iOCase.checkIndexOf(string, n4 + 1, stringArray[n2]);
                        if (n3 >= 0) {
                            stack.push(new int[]{n2, n3});
                        }
                    } else if (!iOCase.checkRegionMatches(string, n4, stringArray[n2])) break;
                    n4 += stringArray[n2].length();
                    n3 = 0;
                }
                ++n2;
            }
            if (n2 != stringArray.length || n4 != string.length()) continue;
            return true;
        } while (stack.size() > 0);
        return false;
    }

    private static String[] splitOnTokens(String object) {
        if (((String)object).indexOf(63) == -1 && ((String)object).indexOf(42) == -1) {
            return new String[]{object};
        }
        object = ((String)object).toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            if (object[i2] == 63 || object[i2] == 42) {
                if (stringBuilder.length() != 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
                if (object[i2] == 63) {
                    arrayList.add("?");
                    continue;
                }
                if (!arrayList.isEmpty() && (i2 <= 0 || ((String)arrayList.get(arrayList.size() - 1)).equals("*"))) continue;
                arrayList.add("*");
                continue;
            }
            stringBuilder.append((char)object[i2]);
        }
        if (stringBuilder.length() != 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

