/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.ThreadMonitor;

public class FileSystemUtils {
    private static final FileSystemUtils INSTANCE;
    private static final int INIT_PROBLEM = -1;
    private static final int OTHER = 0;
    private static final int WINDOWS = 1;
    private static final int UNIX = 2;
    private static final int POSIX_UNIX = 3;
    private static final int OS;
    private static final String DF;

    public static long freeSpace(String string) {
        return INSTANCE.freeSpaceOS(string, OS, false, -1L);
    }

    public static long freeSpaceKb(String string) {
        return FileSystemUtils.freeSpaceKb(string, -1L);
    }

    public static long freeSpaceKb(String string, long l2) {
        return INSTANCE.freeSpaceOS(string, OS, true, l2);
    }

    public static long freeSpaceKb() {
        return FileSystemUtils.freeSpaceKb(-1L);
    }

    public static long freeSpaceKb(long l2) {
        return FileSystemUtils.freeSpaceKb(new File(".").getAbsolutePath(), l2);
    }

    private long freeSpaceOS(String string, int n2, boolean bl, long l2) {
        if (string == null) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        switch (n2) {
            case 1: {
                if (bl) {
                    return this.freeSpaceWindows(string, l2) / 1024L;
                }
                return this.freeSpaceWindows(string, l2);
            }
            case 2: {
                return this.freeSpaceUnix(string, bl, false, l2);
            }
            case 3: {
                return this.freeSpaceUnix(string, bl, true, l2);
            }
            case 0: {
                throw new IllegalStateException("Unsupported operating system");
            }
        }
        throw new IllegalStateException("Exception caught when determining operating system");
    }

    private long freeSpaceWindows(String string, long l2) {
        if ((string = FilenameUtils.normalize(string, false)).length() > 0 && string.charAt(0) != '\"') {
            string = "\"" + string + "\"";
        }
        Object object = new String[]{"cmd.exe", "/C", "dir /a /-c " + string};
        List list = this.performCommand((String[])object, Integer.MAX_VALUE, l2);
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            object = (String)list.get(i2);
            if (object.length() <= 0) continue;
            return this.parseDir((String)object, string);
        }
        throw new IOException("Command line 'dir /-c' did not return any info for path '" + string + "'");
    }

    private long parseDir(String string, String string2) {
        char c2;
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = string.length() - 1; n2 >= 0; --n2) {
            c2 = string.charAt(n2);
            if (!Character.isDigit(c2)) continue;
            n4 = n2 + 1;
            break;
        }
        while (n2 >= 0) {
            c2 = string.charAt(n2);
            if (!Character.isDigit(c2) && c2 != ',' && c2 != '.') {
                n3 = n2 + 1;
                break;
            }
            --n2;
        }
        if (n2 < 0) {
            throw new IOException("Command line 'dir /-c' did not return valid info for path '" + string2 + "'");
        }
        StringBuilder stringBuilder = new StringBuilder(string.substring(n3, n4));
        for (int i2 = 0; i2 < stringBuilder.length(); ++i2) {
            if (stringBuilder.charAt(i2) != ',' && stringBuilder.charAt(i2) != '.') continue;
            stringBuilder.deleteCharAt(i2--);
        }
        return FileSystemUtils.parseBytes(stringBuilder.toString(), string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long freeSpaceUnix(String string, boolean bl, boolean bl2, long l2) {
        String[] stringArray;
        if (string.length() == 0) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        String string2 = "-";
        if (bl) {
            string2 = string2 + "k";
        }
        if (bl2) {
            string2 = string2 + "P";
        }
        if (string2.length() > 1) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = DF;
            stringArray2[1] = string2;
            stringArray = stringArray2;
            stringArray2[2] = string;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = DF;
            stringArray = stringArray3;
            stringArray3[1] = string;
        }
        Object object = stringArray;
        object = this.performCommand((String[])object, 3, l2);
        if (object.size() < 2) {
            throw new IOException("Command line '" + DF + "' did not return info as expected " + "for path '" + string + "'- response was " + object);
        }
        Object object2 = (String)object.get(1);
        if (((StringTokenizer)(object2 = new StringTokenizer((String)object2, " "))).countTokens() < 4) {
            if (((StringTokenizer)object2).countTokens() != 1 || object.size() < 3) throw new IOException("Command line '" + DF + "' did not return data as expected " + "for path '" + string + "'- check path is valid");
            object = (String)object.get(2);
            object2 = new StringTokenizer((String)object, " ");
        } else {
            ((StringTokenizer)object2).nextToken();
        }
        ((StringTokenizer)object2).nextToken();
        ((StringTokenizer)object2).nextToken();
        object = ((StringTokenizer)object2).nextToken();
        return FileSystemUtils.parseBytes((String)object, string);
    }

    private static long parseBytes(String string, String string2) {
        try {
            long l2 = Long.parseLong(string);
            if (l2 < 0L) {
                throw new IOException("Command line '" + DF + "' did not find free space in response " + "for path '" + string2 + "'- check path is valid");
            }
            return l2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOExceptionWithCause("Command line '" + DF + "' did not return numeric data as expected " + "for path '" + string2 + "'- check path is valid", numberFormatException);
        }
    }

    private List performCommand(String[] stringArray, int n2, long l2) {
        ArrayList<Object> arrayList;
        ArrayList<Object> arrayList2 = new ArrayList<Object>(20);
        Process process = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        InputStream inputStream2 = null;
        BufferedReader bufferedReader = null;
        try {
            Thread thread = ThreadMonitor.start(l2);
            Object object = stringArray;
            process = Runtime.getRuntime().exec((String[])object);
            inputStream = process.getInputStream();
            outputStream = process.getOutputStream();
            inputStream2 = process.getErrorStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            object = bufferedReader.readLine();
            while (object != null && arrayList2.size() < n2) {
                object = ((String)object).toLowerCase(Locale.ENGLISH).trim();
                arrayList2.add(object);
                object = bufferedReader.readLine();
            }
            process.waitFor();
            ThreadMonitor.stop(thread);
            if (process.exitValue() != 0) {
                throw new IOException("Command line returned OS error code '" + process.exitValue() + "' for command " + Arrays.asList(stringArray));
            }
            if (arrayList2.isEmpty()) {
                throw new IOException("Command line did not return any info for command " + Arrays.asList(stringArray));
            }
            arrayList = arrayList2;
        }
        catch (InterruptedException interruptedException) {
            try {
                throw new IOExceptionWithCause("Command line threw an InterruptedException for command " + Arrays.asList(stringArray) + " timeout=" + l2, interruptedException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly(inputStream2);
                IOUtils.closeQuietly(bufferedReader);
                if (process != null) {
                    process.destroy();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        IOUtils.closeQuietly(outputStream);
        IOUtils.closeQuietly(inputStream2);
        IOUtils.closeQuietly(bufferedReader);
        if (process != null) {
            process.destroy();
        }
        return arrayList;
    }

    private static Process openProcess(String[] stringArray) {
        return Runtime.getRuntime().exec(stringArray);
    }

    static {
        int n2;
        INSTANCE = new FileSystemUtils();
        boolean bl = false;
        String string = "df";
        try {
            String string2 = System.getProperty("os.name");
            if (string2 == null) {
                throw new IOException("os.name not found");
            }
            if ((string2 = string2.toLowerCase(Locale.ENGLISH)).indexOf("windows") != -1) {
                n2 = 1;
            } else if (string2.indexOf("linux") != -1 || string2.indexOf("mpe/ix") != -1 || string2.indexOf("freebsd") != -1 || string2.indexOf("irix") != -1 || string2.indexOf("digital unix") != -1 || string2.indexOf("unix") != -1 || string2.indexOf("mac os x") != -1) {
                n2 = 2;
            } else if (string2.indexOf("sun os") != -1 || string2.indexOf("sunos") != -1 || string2.indexOf("solaris") != -1) {
                n2 = 3;
                string = "/usr/xpg4/bin/df";
            } else {
                n2 = string2.indexOf("hp-ux") != -1 || string2.indexOf("aix") != -1 ? 3 : 0;
            }
        }
        catch (Exception exception) {
            n2 = -1;
        }
        OS = n2;
        DF = string;
    }
}

